% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.R
\name{calcite_panel}
\alias{calcite_panel}
\title{Create a Calcite Panel Component}
\usage{
calcite_panel(
  ...,
  id = NULL,
  heading = NULL,
  description = NULL,
  closable = NULL,
  closed = NULL,
  collapsed = NULL,
  collapse_direction = NULL,
  collapsible = NULL,
  disabled = NULL,
  heading_level = NULL,
  icon = NULL,
  icon_flip_rtl = NULL,
  loading = NULL,
  menu_flip_placements = NULL,
  menu_open = NULL,
  menu_placement = NULL,
  message_overrides = NULL,
  overlay_positioning = NULL,
  scale = NULL,
  action_bar = NULL,
  alerts = NULL,
  content_bottom = NULL,
  content_top = NULL,
  header_actions_start = NULL,
  header_actions_end = NULL,
  header_content = NULL,
  header_menu_actions = NULL,
  fab = NULL,
  footer = NULL,
  footer_start = NULL,
  footer_end = NULL
)
}
\arguments{
\item{...}{Main content for the panel (default slot)}

\item{id}{Component ID (required for Shiny reactivity)}

\item{heading}{Header text for the panel}

\item{description}{Description text displayed below the heading}

\item{closable}{Whether to display a close button in the header (default: FALSE)}

\item{closed}{Whether the component is hidden (default: FALSE)}

\item{collapsed}{Whether the content area is hidden (default: FALSE)}

\item{collapse_direction}{Direction of collapse icon: "down" or "up" (default: "down")}

\item{collapsible}{Whether the panel can be collapsed (default: FALSE)}

\item{disabled}{Whether interaction is prevented (default: FALSE)}

\item{heading_level}{Semantic heading level (1-6) for accessibility}

\item{icon}{Icon to display in the header}

\item{icon_flip_rtl}{Flip icon in RTL languages (default: FALSE)}

\item{loading}{Whether to display a busy indicator (default: FALSE)}

\item{menu_flip_placements}{Fallback placements for the menu when space is insufficient}

\item{menu_open}{Whether the action menu items are open (default: FALSE)}

\item{menu_placement}{Placement of the action menu (default: "bottom-end")}

\item{message_overrides}{Override individual strings used by the component}

\item{overlay_positioning}{Positioning type for overlaid content: "absolute" or "fixed" (default: "absolute")}

\item{scale}{Size of the component: "s" (small), "m" (medium), or "l" (large) (default: "m")}

\item{action_bar}{Content for the action-bar slot (typically \code{\link[=calcite_action_bar]{calcite_action_bar()}})}

\item{alerts}{Content for the alerts slot (typically \code{\link[=calcite_alert]{calcite_alert()}} components)}

\item{content_bottom}{Content below the main slot and above the footer}

\item{content_top}{Content above the main slot and below the action-bar}

\item{header_actions_start}{Actions or content at the start of the header}

\item{header_actions_end}{Actions or content at the end of the header}

\item{header_content}{Custom content for the header}

\item{header_menu_actions}{Overflow menu with actions (typically in \code{\link[=calcite_dropdown]{calcite_dropdown()}})}

\item{fab}{Floating action button (typically \code{\link[=calcite_fab]{calcite_fab()}})}

\item{footer}{Custom content for the footer (don't use with footer_start/footer_end)}

\item{footer_start}{Leading footer content (don't use with footer slot)}

\item{footer_end}{Trailing footer content (don't use with footer slot)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Panel is a container that can house interactions as well as live within other
Calcite Components. It provides a header with heading text and a summary, and
slots to add Actions and Icons to the start and end of the header.
}
\details{
\subsection{Shiny Integration}{

The panel emits events when it's closed, collapsed, expanded, scrolled, or toggled.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$closable} - Whether the close button is displayed
\item \verb{$closed} - Whether the panel is hidden
\item \verb{$collapsed} - Whether the content area is collapsed
\item \verb{$collapsible} - Whether the panel is collapsible
\item \verb{$disabled} - Whether the panel is disabled
\item Other component properties
}

\strong{Events:}
\itemize{
\item \code{calcitePanelClose} - Fires when the close button is clicked
\item \code{calcitePanelCollapse} - Fires when the content area is collapsed
\item \code{calcitePanelExpand} - Fires when the content area is expanded
\item \code{calcitePanelScroll} - Fires when the content is scrolled
\item \code{calcitePanelToggle} - Fires when the collapse button is clicked
}
}
}
\examples{
# Basic panel with heading
calcite_panel(
  id = "my_panel",
  heading = "Map Options",
  "Panel content goes here..."
)

# Collapsible panel with icon
calcite_panel(
  heading = "Layer effects",
  description = "Adjust blur, highlight, and more",
  collapsible = TRUE,
  icon = "effects",
  "Panel content"
)

# Panel with header actions and footer
calcite_panel(
  heading = "Settings",
  header_actions_start = calcite_action(
    icon = "question",
    text = "Help",
    slot = "header-actions-start"
  ),
  header_actions_end = calcite_action(
    icon = "save",
    text = "Save",
    slot = "header-actions-end"
  ),
  footer = htmltools::tagList(
    calcite_button(width = "half", appearance = "outline", "Cancel"),
    calcite_button(width = "half", "Save")
  ),
  "Panel content"
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/panel/}{Official Documentation}
}
