% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option.R
\name{calcite_option}
\alias{calcite_option}
\title{Create a Calcite Option Component}
\usage{
calcite_option(label, value, disabled = NULL, selected = NULL, ...)
}
\arguments{
\item{label}{Text label for the option (required for accessibility)}

\item{value}{The component's value (can be any type)}

\item{disabled}{When true, interaction is prevented and the component is displayed with lower opacity}

\item{selected}{When true, the component is selected}

\item{...}{Additional attributes passed to the component}
}
\value{
An object of class \code{calcite_component}
}
\description{
Option provides a selectable item within a \code{\link[=calcite_select]{calcite_select()}} component.
Each option represents a single choice in the select dropdown menu.
}
\details{
Options are used within \code{\link[=calcite_select]{calcite_select()}} to define the available choices.
The \code{value} parameter determines what value will be sent to Shiny when the
option is selected.
}
\examples{
# Basic option
calcite_option(
  label = "First Option",
  value = "1"
)

# Selected option
calcite_option(
  label = "Default Selection",
  value = "default",
  selected = TRUE
)

# Disabled option
calcite_option(
  label = "Unavailable",
  value = "unavailable",
  disabled = TRUE
)

# Use with calcite_select
calcite_select(
  id = "my_select",
  label = "Choose one",
  calcite_option(label = "Option 1", value = "1"),
  calcite_option(label = "Option 2", value = "2", selected = TRUE),
  calcite_option(label = "Option 3", value = "3")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/option/}{Official Documentation}
}
