% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{calcite_label}
\alias{calcite_label}
\title{Create a Calcite Label Component}
\usage{
calcite_label(
  label,
  ...,
  target_id = NULL,
  id = NULL,
  alignment = NULL,
  layout = NULL,
  scale = NULL
)
}
\arguments{
\item{label}{The label text (required)}

\item{...}{Child components to wrap within the label (e.g., calcite_input_text())}

\item{target_id}{The id of the component this label is bound to (only needed when
the labeled component is outside the label). Maps to the \code{for} HTML attribute}

\item{id}{Component ID (optional)}

\item{alignment}{Specifies the text alignment of the component: "start", "center",
or "end" (default: "start")}

\item{layout}{Defines the layout of the label: "block", "default", "inline",
or "inline-space-between" (default: "default").
Note: "default" is deprecated, use "block" instead}

\item{scale}{Specifies the size of the component: "s" (small), "m" (medium),
or "l" (large) (default: "m")}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a label component that wraps and provides accessible text for form controls
and other interactive elements.
}
\examples{
# Label wrapping an input
calcite_label(
  label = "Username",
  calcite_input_text(
    id = "username",
    placeholder = "Enter username"
  )
)

# Label with inline layout
calcite_label(
  label = "Subscribe",
  layout = "inline",
  calcite_checkbox(id = "subscribe")
)

# Label with external component (using target_id)
htmltools::tagList(
  calcite_label(
    label = "Password",
    target_id = "password"
  ),
  calcite_input_text(id = "password", placeholder = "Enter password")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/label/}{Official Documentation}
}
