% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-file.R
\name{calcite_input_file}
\alias{calcite_input_file}
\title{Create a Calcite File Input Component}
\usage{
calcite_input_file(
  id = NULL,
  accept = NULL,
  multiple = FALSE,
  disabled = NULL,
  label = NULL,
  label_text = NULL,
  required = NULL,
  scale = NULL,
  validation_icon = NULL,
  validation_message = NULL
)
}
\arguments{
\item{id}{Component ID (required for Shiny reactivity)}

\item{accept}{A character vector of accepted file extensions without the
leading period (e.g. \code{c("csv", "tsv", "txt")}). MIME types are also
accepted (e.g. \code{"text/plain"}). When \code{NULL}, all file types are accepted.}

\item{multiple}{When \code{TRUE}, the user can select more than one file.
Must be a scalar logical. Default \code{FALSE}.}

\item{disabled}{When \code{TRUE}, prevents interaction and decreases opacity.}

\item{label}{Accessible label for the component.}

\item{label_text}{Label text displayed on the component.}

\item{required}{When \code{TRUE}, a file must be selected for form submission.}

\item{scale}{Size of the component: \code{"s"}, \code{"m"}, or \code{"l"}.}

\item{validation_icon}{Validation icon to display (\code{TRUE} or an icon name).}

\item{validation_message}{Validation message to display under the component.}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a file input component for selecting files from the user's device.
Use the \code{accept} argument to restrict which file types can be selected.
This component works by syncing with Shiny's native file upload mechanism
to handle file transfers to the server.
}
\details{
\subsection{Shiny Integration}{

When used in a Shiny app, \code{calcite_input_file()} works like \code{\link[shiny:fileInput]{shiny::fileInput()}}
and returns a data frame via \code{input$id} with one row per uploaded file.

\strong{Columns in \code{input$id}:}
\itemize{
\item \code{name} - The filename provided by the browser
\item \code{size} - File size in bytes
\item \code{type} - MIME type (e.g., \code{"text/csv"})
\item \code{datapath} - Path to a temp file containing the uploaded data. Use this
path to read the file contents (e.g., \code{read.csv(input$my_file$datapath[1])})
}

The uploaded files are stored in a temporary directory and will be deleted
when the Shiny session ends.
}
}
\examples{
# Accept CSV files only
calcite_input_file(
  id = "my_file",
  accept = "csv",
  label_text = "Upload a CSV file"
)

# Accept multiple image formats
calcite_input_file(
  id = "my_file",
  accept = c("png", "jpg", "jpeg", "gif"),
  multiple = TRUE,
  label_text = "Upload images"
)

if (interactive()) {
  library(shiny)

  ui <- calcite_shell(
    calcite_panel(
      heading = "File Upload",
      calcite_input_file(
        id = "csv_upload",
        accept = "csv",
        label_text = "Upload CSV"
      ),
      tableOutput("contents")
    )
  )

  server <- function(input, output, session) {
    output$contents <- renderTable({
      req(input$csv_upload)
      read.csv(input$csv_upload$datapath[1])
    })
  }

  shinyApp(ui, server)
}
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/input/}{Official Documentation}
}
