% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-picker.R
\name{calcite_date_picker}
\alias{calcite_date_picker}
\title{Create a Calcite Date Picker Component}
\usage{
calcite_date_picker(
  id = NULL,
  value = NULL,
  range = NULL,
  min = NULL,
  max = NULL,
  scale = NULL,
  layout = NULL,
  calendars = NULL,
  active_range = NULL,
  heading_level = NULL,
  month_style = NULL,
  numbering_system = NULL,
  proximity_selection_disabled = NULL,
  ...
)
}
\arguments{
\item{id}{Optional ID for the date picker (required for Shiny reactivity)}

\item{value}{Selected date as a string ("yyyy-mm-dd"), or array of strings for range values}

\item{range}{When TRUE, activates range mode to allow start and end dates (default: FALSE)}

\item{min}{Earliest allowed date ("yyyy-mm-dd")}

\item{max}{Latest allowed date ("yyyy-mm-dd")}

\item{scale}{Specifies size of the component: "s" (small), "m" (medium), or "l" (large)}

\item{layout}{Defines the layout: "horizontal" or "vertical"}

\item{calendars}{Number of calendars displayed when range is TRUE: 1 or 2 (default: 2)}

\item{active_range}{When range is TRUE, specifies active range: "start" or "end"}

\item{heading_level}{Heading level for document structure (1-6)}

\item{month_style}{Month display style: "wide" (default) or "abbreviated"}

\item{numbering_system}{Unicode numeral system: "latn", "arab", or "arabext"}

\item{proximity_selection_disabled}{When TRUE, disables default range narrowing behavior (default: FALSE)}

\item{...}{Additional attributes passed to the component}
}
\value{
An object of class \code{calcite_component}
}
\description{
Provides a calendar interface for selecting dates. Supports single date
selection or date range selection with various customization options.
}
\details{
\subsection{Date Formats}{
\itemize{
\item Dates should be provided as strings in "yyyy-mm-dd" format
\item For range mode, provide an array: \code{c("2024-01-15", "2024-01-20")}
\item The component always returns dates as an array of strings, even in single date mode
}
}

\subsection{Shiny Integration}{

When used in a Shiny app with an \code{id}, \code{calcite_date_picker()} returns a reactive
list containing component properties.

\strong{Available properties:}
\itemize{
\item \verb{$value} - Array of selected date strings (always an array, even for single dates)
\item \verb{$range} - Whether range mode is enabled
\item \verb{$min} - Minimum allowed date
\item \verb{$max} - Maximum allowed date
\item Other component properties
}

\strong{Usage in server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Single date mode
observeEvent(input$my_date$value, \{
  selected_date <- input$my_date$value[1]  # Get first (and only) date
  message("Selected: ", selected_date)
\})

# Range mode
observeEvent(input$my_date_range$value, \{
  start_date <- input$my_date_range$value[1]
  end_date <- input$my_date_range$value[2]
  message("Range: ", start_date, " to ", end_date)
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic date picker
calcite_date_picker(
  id = "my_date"
)

# Date picker with initial value
calcite_date_picker(
  id = "event_date",
  value = "2024-12-25"
)

# Date picker with min/max constraints
calcite_date_picker(
  id = "booking_date",
  min = "2024-01-01",
  max = "2024-12-31"
)

# Range date picker
calcite_date_picker(
  id = "date_range",
  range = TRUE,
  value = c("2024-01-15", "2024-01-20")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/date-picker/}{Official Documentation}
}
