% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alert.R
\name{calcite_alert}
\alias{calcite_alert}
\alias{calcite_alert_brand}
\alias{calcite_alert_danger}
\alias{calcite_alert_info}
\alias{calcite_alert_success}
\alias{calcite_alert_warning}
\title{Create a Calcite Alert Component}
\usage{
calcite_alert(
  kind = NULL,
  ...,
  id = NULL,
  label = NULL,
  open = NULL,
  icon = TRUE,
  icon_flip_rtl = NULL,
  auto_close = NULL,
  auto_close_duration = NULL,
  placement = NULL,
  queue = NULL,
  scale = NULL,
  numbering_system = NULL,
  title = NULL,
  message = NULL,
  link = NULL,
  actions_end = NULL
)

calcite_alert_brand(
  ...,
  id = NULL,
  label = NULL,
  open = NULL,
  icon = TRUE,
  icon_flip_rtl = NULL,
  auto_close = NULL,
  auto_close_duration = NULL,
  placement = NULL,
  queue = NULL,
  scale = NULL,
  numbering_system = NULL,
  title = NULL,
  message = NULL,
  link = NULL,
  actions_end = NULL
)

calcite_alert_danger(
  ...,
  id = NULL,
  label = NULL,
  open = NULL,
  icon = TRUE,
  icon_flip_rtl = NULL,
  auto_close = NULL,
  auto_close_duration = NULL,
  placement = NULL,
  queue = NULL,
  scale = NULL,
  numbering_system = NULL,
  title = NULL,
  message = NULL,
  link = NULL,
  actions_end = NULL
)

calcite_alert_info(
  ...,
  id = NULL,
  label = NULL,
  open = NULL,
  icon = TRUE,
  icon_flip_rtl = NULL,
  auto_close = NULL,
  auto_close_duration = NULL,
  placement = NULL,
  queue = NULL,
  scale = NULL,
  numbering_system = NULL,
  title = NULL,
  message = NULL,
  link = NULL,
  actions_end = NULL
)

calcite_alert_success(
  ...,
  id = NULL,
  label = NULL,
  open = NULL,
  icon = TRUE,
  icon_flip_rtl = NULL,
  auto_close = NULL,
  auto_close_duration = NULL,
  placement = NULL,
  queue = NULL,
  scale = NULL,
  numbering_system = NULL,
  title = NULL,
  message = NULL,
  link = NULL,
  actions_end = NULL
)

calcite_alert_warning(
  ...,
  id = NULL,
  label = NULL,
  open = NULL,
  icon = TRUE,
  icon_flip_rtl = NULL,
  auto_close = NULL,
  auto_close_duration = NULL,
  placement = NULL,
  queue = NULL,
  scale = NULL,
  numbering_system = NULL,
  title = NULL,
  message = NULL,
  link = NULL,
  actions_end = NULL
)
}
\arguments{
\item{kind}{Specifies the kind of alert: "brand", "danger", "info", "success", or "warning" (default: "brand")}

\item{...}{Child content for the alert}

\item{id}{Component ID (required for Shiny reactivity)}

\item{label}{Accessible name for the component (required)}

\item{open}{When true, displays and positions the component (default: FALSE)}

\item{icon}{When TRUE, shows a default recommended icon. Alternatively, pass a Calcite UI Icon name to display a specific icon}

\item{icon_flip_rtl}{When TRUE, the icon will be flipped when the element direction is right-to-left}

\item{auto_close}{When TRUE, the component closes automatically. Recommended for passive, non-blocking alerts (default: FALSE)}

\item{auto_close_duration}{Duration before auto-close: "fast", "medium", or "slow" (default: "medium")}

\item{placement}{Placement of the component: "top", "top-start", "top-end", "bottom", "bottom-start", or "bottom-end" (default: "bottom")}

\item{queue}{Ordering priority when opened: "immediate", "last", or "next" (default: "last")}

\item{scale}{Size of the component: "s" (small), "m" (medium), or "l" (large) (default: "m")}

\item{numbering_system}{Unicode numeral system for localization: "arab", "arabext", or "latn"}

\item{title}{Content for the title slot}

\item{message}{Content for the message slot}

\item{link}{Content for the link slot (typically \code{\link[=calcite_link]{calcite_link()}})}

\item{actions_end}{Content for the actions-end slot (typically \code{\link[=calcite_action]{calcite_action()}} components)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Alerts are meant to quickly convey a message to the user. They are ephemeral,
workflow-specific messaging that is positioned absolutely over content.
}
\details{
\subsection{Best Practices}{

While visually similar to Notice, Alert has distinct capabilities and intended use cases:

\strong{Alert:}
\itemize{
\item Best for ephemeral, workflow-specific messaging
\item Generally should not be open at page load
\item Most often displayed as a result of user interaction
\item Positioned absolutely over content
}

\strong{Notice:}
\itemize{
\item Best for informative, contextually relevant information
\item Can be open at page load, or displayed as a result of user action
\item Can be persisted in the interface or made closable
}

\strong{Modal:}
\itemize{
\item Best for long-form messaging or narrative content
\item Can contain media or interactive elements
\item Generally presented as a result of user invocation
}
}

\subsection{Writing and Copy}{

Alerts are meant to quickly convey a message to the user. Keep copy short and to the point.
Consistent Alert structure, verbiage, and copy ensures users have an expected experience.
}

\subsection{Shiny Integration}{

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$open} - Whether the alert is currently displayed
\item \verb{$kind} - The alert kind
\item Other component properties
}

\strong{Events:}
\itemize{
\item \code{calciteAlertBeforeClose} - Before closing transition begins
\item \code{calciteAlertBeforeOpen} - Before opening transition begins
\item \code{calciteAlertClose} - After close animation completes
\item \code{calciteAlertOpen} - After open animation completes
}
}
}
\examples{
# Basic success alert
calcite_alert_success(
  label = "Success",
  icon = "smile",
  open = TRUE,
  title = "Everything worked out!",
  message = "Take a moment to reflect on your day"
)

# Alert with link
calcite_alert_info(
  label = "Notification",
  open = TRUE,
  title = "Something interesting just happened",
  message = "We thought you might want to take a look",
  link = calcite_link("Take action", href = "#")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/alert/}{Official Documentation}
}
