% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion-item.R
\name{calcite_accordion_item}
\alias{calcite_accordion_item}
\title{Create a Calcite Accordion Item Component}
\usage{
calcite_accordion_item(
  ...,
  id = NULL,
  heading = NULL,
  description = NULL,
  expanded = NULL,
  heading_level = NULL,
  icon_start = NULL,
  icon_end = NULL,
  icon_flip_rtl = NULL,
  actions_start = NULL,
  actions_end = NULL,
  content_start = NULL,
  content_end = NULL
)
}
\arguments{
\item{...}{Child content for the accordion item (default slot)}

\item{id}{Component ID (required for Shiny reactivity)}

\item{heading}{Heading text for the accordion item}

\item{description}{Description text displayed in the header}

\item{expanded}{Whether the item is currently expanded (default: FALSE)}

\item{heading_level}{Semantic heading level (1-6) for accessibility}

\item{icon_start}{Icon to display at the start of the header}

\item{icon_end}{Icon to display at the end of the header}

\item{icon_flip_rtl}{Flip icons in RTL languages: "start", "end", or "both"}

\item{actions_start}{Content for the actions-start slot}

\item{actions_end}{Content for the actions-end slot}

\item{content_start}{Content for the content-start slot}

\item{content_end}{Content for the content-end slot}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates an individual accordion item that can be used within a calcite-accordion.
Accordion items can be expanded and collapsed to show or hide content.
}
\details{
\subsection{Shiny Integration}{

The accordion item emits events when it's expanded or collapsed.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$expanded} - Whether the item is currently expanded
\item \verb{$heading} - The heading text
\item \verb{$description} - The description text
\item Other component properties
}

\strong{Basic usage:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{calcite_accordion_item(
  id = "item1",
  heading = "Watercraft",
  description = "Yachts, boats, and dinghies",
  icon_start = "embark",
  # Item content...
)

# In server
observeEvent(input$item1$expanded, \{
  if (input$item1$expanded) \{
    message("Item was expanded")
  \} else \{
    message("Item was collapsed")
  \}
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic accordion item
calcite_accordion_item(
  id = "watercraft",
  heading = "Watercraft",
  description = "Yachts, boats, and dinghies",
  icon_start = "embark",
  "Content goes here..."
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/accordion-item/}{Official Documentation}
}
