% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_update_plan.R
\docType{methods}
\name{update_plan<-}
\alias{update_plan<-}
\alias{update_plan}
\alias{update_plan<-,transaction_plan-method}
\alias{update_plan<-,-methods}
\title{Update transaction_plan objects}
\usage{
update_plan(obj) <- value

\S4method{update_plan}{transaction_plan}(obj) <- value
}
\arguments{
\item{obj}{An object of class \code{\link[businessPlanR:transaction_plan-class]{transaction_plan}}.}

\item{value}{An object of class \code{\link[businessPlanR:depreciation-class]{depreciation}} or
\code{\link[businessPlanR:loan-class]{loan}}.}
}
\value{
An updated object of class \code{transaction_plan}.
}
\description{
You can use this method to add or replace \code{\link[businessPlanR:depreciation-class]{depreciation}} or
\code{\link[businessPlanR:loan-class]{loan}} class objects to/in an existing object of class
\code{\link[businessPlanR:transaction_plan-class]{transaction_plan}}.
}
\examples{
depreciation_printer <- depreciation(
    type="Depreciation",
    category="Office",
    name="Printer",
    amount=100,
    obsolete=36,
    invest_month="2019.04"
)
depreciation_laptop <- depreciation(
    type="Depreciation",
    category="Office",
    name="Laptop",
    amount=1200,
    obsolete=36,
    invest_month="2019.02"
)
# initialize an empty plan
dep_plan <- transaction_plan()
# add your assets to the plan
update_plan(dep_plan) <- depreciation_printer
update_plan(dep_plan) <- depreciation_laptop
}
