% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_auth.R
\name{bunddev_auth_set}
\alias{bunddev_auth_set}
\title{Set authentication configuration for an API}
\usage{
bunddev_auth_set(
  api,
  type = "api_key",
  env_var,
  scheme = NULL,
  oauth_url = NULL,
  oauth_secret_env = NULL,
  oauth_default_id = NULL,
  oauth_token_header = "OAuthAccessToken",
  oauth_fallback_header = "X-API-Key"
)
}
\arguments{
\item{api}{Registry id.}

\item{type}{Authentication type ("none", "api_key", or "oauth2").}

\item{env_var}{Environment variable containing credentials (for api_key) or client ID (for oauth2).}

\item{scheme}{Authentication scheme used in the Authorization header (e.g., "Bearer", "ApiKey", "OAuth").}

\item{oauth_url}{OAuth2 token endpoint URL (for oauth2 type).}

\item{oauth_secret_env}{OAuth2 client secret environment variable (for oauth2 type).}

\item{oauth_default_id}{Default OAuth2 client ID if env_var is not set (for oauth2 type).}

\item{oauth_token_header}{Header name for OAuth token (default "OAuthAccessToken").}

\item{oauth_fallback_header}{Header name when no secret available (default "X-API-Key").}
}
\value{
The updated auth configuration.
}
\description{
Set authentication configuration for an API
}
\details{
Store auth configuration used by \code{\link[=bunddev_call]{bunddev_call()}} and adapter helpers.

For API key auth: set \code{env_var} to the name of an environment variable containing
the key. The key is sent as \verb{Authorization: \{scheme\} <key>}.

For OAuth2 client credentials: set \code{oauth_url} to the token endpoint,
\code{env_var} to the client ID env var, and \code{oauth_secret_env} to the client secret
env var. If the secret is available, fetches an OAuth token; otherwise falls
back to sending the client ID as an API key.
}
\examples{
# API key authentication
Sys.setenv(JOBBOERSE_API_KEY = "jobboerse-jobsuche")
bunddev_auth_set("jobsuche", type = "api_key", env_var = "JOBBOERSE_API_KEY", scheme = "X-API-Key")

# OAuth2 client credentials
bunddev_auth_set("berufssprachkurssuche",
  type = "oauth2",
  oauth_url = "https://rest.arbeitsagentur.de/oauth/gettoken_cc",
  env_var = "BERUFSSPRACHKURSSUCHE_API_KEY",
  oauth_secret_env = "BERUFSSPRACHKURSSUCHE_CLIENT_SECRET",
  oauth_default_id = "bd24f42e-ad0b-4005-b834-23bb6800dc6c")

}
\seealso{
\code{\link[=bunddev_auth_get]{bunddev_auth_get()}} to inspect the stored configuration, and
\code{\link[=bunddev_call]{bunddev_call()}} to make authenticated requests.
}
