% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13_ratioPutSpreadGraph.R
\name{ratioPutSpread}
\alias{ratioPutSpread}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven point at expiration for Ratio Put Spread and draws its graph in the Plots tab.}
\usage{
ratioPutSpread(
  ST,
  X2H,
  X1L,
  PX2H,
  PX1L,
  hl = 0,
  hu = 1.7,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Ratio Put Spread ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X2H}{Higher Strike Price or eXercise price.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{PX2H}{Premium received for the sold s at higher Strike.}

\item{PX1L}{Premium paid for the bought s at Lower Strike.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Ratio Put Spread.
}
\description{
This strategy consists of a short position in NS close to ATM put options with a strike price X1L, and a long position in NL ITM put options with a strike price X2H, where NL is less than NS. Typically, NL is equal to 1 and NS is equal to 2, or NL is 2 and NS is 3. This is an income strategy if it is structured as a net credit trade. The trader’s outlook is neutral to bullish (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for Ratio Put Spread and draws its graph in the Plots tab.
}
\examples{
ratioPutSpread(25,30,25,1.33,0.42)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
