% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_aLongCall.R
\name{aLongCall}
\alias{aLongCall}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE) point at expiration for European Long Call and draws its graph in the Plots tab.}
\usage{
aLongCall(
  ST,
  X,
  C,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Long Call ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium paid on bought call.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Long Call.
}
\description{
A long call gives trader or investor the right to buy in return of the call premium or call price paid to secure this right from the call seller. The call buyer hopes that the underlying share price will rise that would result in profits (Kakushadze & Serur, 2018).
}
\details{
This method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for a long call and draws its graph in the Plots tab.
}
\examples{
aLongCall(17,17,1.44)
aLongCall(50,50,4,hl=0.7,hu=1.2)
aLongCall(1000,1000,10,hl=0.97,hu=1.02)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
