% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_helpers.R
\name{result}
\alias{result}
\title{Fluent tournament result entry helper}
\usage{
result(tournament, stage, match, score, overwrite = FALSE, auto_advance = NULL)
}
\arguments{
\item{tournament}{A \code{tournament} object.}

\item{stage}{Stage identifier containing the match.}

\item{match}{Match identifier inside \code{stage}.}

\item{score}{Numeric vector score payload. For a single match, pass
\code{c(score1, score2)}.}

\item{overwrite}{Logical; forwards to \code{set_result(..., overwrite = ...)}.}

\item{auto_advance}{Optional logical override. If \code{NULL}, defaults to the
tournament's \code{auto_advance} setting when present.}
}
\value{
Updated \code{tournament} object.
}
\description{
Convenience wrapper around \code{set_result()} for tournament workflows.
}
\examples{
teams <- c("A", "B", "C", "D")
trn <- tournament(teams) |>
  round_robin("groups")

# Enter a single result
trn <- result(trn, "groups", match = 1, score = c(2, 1))
}
