% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.assessEncodingQuality}
\alias{.assessEncodingQuality}
\title{Assess encoding quality}
\usage{
.assessEncodingQuality(
  values,
  type,
  enc = NULL,
  isRaster = FALSE,
  rasterLevels = NULL,
  range = NULL,
  decimals = NULL,
  max_bits = 16L,
  fields = NULL,
  errorOnAllNA = FALSE
)
}
\arguments{
\item{values}{vector of values to assess (will be cleaned of NAs internally)}

\item{type}{encoding type ("bool", "enum", "int", "float")}

\item{enc}{list with encoding parameters (sign, exponent, significand, bias).
If NULL (for bf_analyze), type-appropriate defaults or multiple configs are tested.}

\item{isRaster}{logical, whether data comes from a SpatRaster (enum only)}

\item{rasterLevels}{data.frame with raster attribute table (enum only)}

\item{range}{optional target range c(min, max) for float analysis}

\item{decimals}{optional decimal precision for float comparison}

\item{max_bits}{maximum total bits to consider (default 16)}

\item{fields}{optional list specifying which exp/sig configurations to analyze (float only)}
}
\value{
list of quality metrics appropriate for the encoding type. For float
without specific enc, returns a list with data summary and results data.frame.
}
\description{
Internal function to analyze data and compute quality metrics for encoding.
This function is used both by \code{bf_analyze} for user-facing analysis and by
\code{bf_map} to store quality metrics in the provenance.
}
\keyword{internal}
