% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_registry.R
\name{bf_registry}
\alias{bf_registry}
\title{Initiate a new registry}
\usage{
bf_registry(
  name,
  description,
  template,
  author = NULL,
  project = NULL,
  license = "MIT"
)
}
\arguments{
\item{name}{\code{\link[=character]{character(1)}}\cr the name of the bitfield.}

\item{description}{\code{\link[=character]{character(1)}}\cr the description of the
bitfield.}

\item{template}{the data object that serves as a template for the bitfield
structure. Can be a \code{data.frame} (or \code{tibble}) or a
\code{SpatRaster}. The template determines the output format of
\code{\link{bf_encode}} and \code{\link{bf_decode}}.}

\item{author}{\code{\link[=person]{person(.)}}\cr the author(s) involved in the creation
of this registry.}

\item{project}{\code{\link[=list]{list(1)}}\cr object created with the function
\code{\link{project}} that documents the project metadata.}

\item{license}{\code{\link[=character]{character(1)}}\cr license or rights statement.}
}
\value{
an empty registry that captures some metadata of the bitfield, but
doesn't contain any flags yet.
}
\description{
Initiate a new registry
}
\examples{
auth <- person(given = "Jane", family = "Smith",
               email = "jane@example.com", role = c("cre", "aut"))

proj <- project(title = "example project",
                people = c(person("Jane", "Smith", email = "jane@example.com",
                                  role = "aut"),
                           person("Robert", "Jones", role = c("aut", "cre"))),
                publisher = "example publisher",
                type = "Dataset",
                identifier = "10.5281/zenodo.1234567",
                description = "A comprehensive explanation",
                subject = c("keyword", "subject"),
                license = "CC-BY-4.0")

# with a data.frame template
reg <- bf_registry(name = "currentWorkflow",
                   description = "the registry to my modelling pipeline",
                   template = bf_tbl,
                   author = auth,
                   project = proj)

# with a raster template
library(terra)
bf_rst <- rast(nrows = 3, ncols = 3, vals = 1:9)
reg <- bf_registry(name = "rasterWorkflow",
                   description = "raster-based bitfield",
                   template = bf_rst)
}
