% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_encode.R
\name{bf_encode}
\alias{bf_encode}
\title{Encode bit flags into a bitfield}
\usage{
bf_encode(registry)
}
\arguments{
\item{registry}{\code{\link[=registry]{registry(1)}}\cr the registry that should be
encoded into a bitfield.}
}
\value{
Depending on the registry template type: a \code{data.frame} with
integer columns (one per 32-bit chunk) if template is a table, or a
\code{SpatRaster} with integer layers if template is a raster.
}
\description{
This function picks up the flags mentioned in a registry and encodes them as
integer values.
}
\examples{
reg <- bf_registry(name = "testBF", description = "test bitfield",
                   template = bf_tbl)
reg <- bf_map(protocol = "na", data = bf_tbl, registry = reg, x = y)

field <- bf_encode(registry = reg)

# with raster data
library(terra)
bf_rst <- rast(nrows = 3, ncols = 3, vals = bf_tbl$commodity, names = "commodity")
bf_rst$yield <- rast(nrows = 3, ncols = 3, vals = bf_tbl$yield)

reg <- bf_registry(name = "testBF", description = "raster bitfield",
                   template = bf_rst)
reg <- bf_map(protocol = "na", data = bf_rst, registry = reg, x = commodity)

field <- bf_encode(registry = reg)  # returns a SpatRaster
}
