% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins.R
\name{bins.getvals}
\alias{bins.getvals}
\title{Extract Cut Points from Bins Object}
\usage{
bins.getvals(lst, minpt = -Inf, maxpt = Inf)
}
\arguments{
\item{lst}{The list returned by the \code{\link{bins}} function.}

\item{minpt}{The value replacing the lower bound of the cut points.}

\item{maxpt}{The value replacing the upper bound of the cut points.}
}
\value{
A vector of cut points extracted from the
\code{lst} object. The actual low and high values in each bin, as well
as the counts of values in each bin are placed in attributes
\code{binlo}, \code{binhi} and \code{binct}, respectively.
}
\description{
Extracts cut points from the object returned by \code{\link{bins}}.
The cut points are always between the values in \code{x} and weighed such that
the cut point splits the area under the line from (lo, n1) to (hi, n2) in half.
}
\seealso{
\code{\link{bins}}
}
