% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_notices.R
\name{bid_telemetry}
\alias{bid_telemetry}
\title{Concise telemetry analysis with tidy output}
\usage{
bid_telemetry(
  source,
  format = NULL,
  events_table = NULL,
  table_name = NULL,
  thresholds = list()
)
}
\arguments{
\item{source}{Either a file path to telemetry data or a DBI connection object.
Supports:
\itemize{
\item SQLite databases (shiny.telemetry or OTEL format)
\item JSON files (shiny.telemetry logs or OTLP JSON exports)
\item DBI connections to databases with event or span tables
When a connection is provided, it will not be closed by this function.
}}

\item{format}{Optional format specification ("sqlite", "json", "otlp_json",
"otel_sqlite"). If NULL (default), auto-detected from file extension and
structure. OTLP formats are automatically detected when file contains
OpenTelemetry span data.}

\item{events_table}{Optional data.frame specifying custom events table when
reading from SQLite. Must have columns: event_id, timestamp,
event_type, user_id. If NULL, auto-detects standard table names
(event_data, events). Cannot be used with \code{table_name}.}

\item{table_name}{Optional character string specifying the table name to read
from the database. If NULL (default), auto-detects standard table names
(event_data, events). Cannot be used with \code{events_table}.}

\item{thresholds}{Optional list of threshold parameters:
- unused_input_threshold: percentage of sessions below which input is
considered unused (default: 0.05)
- delay_threshold_secs: seconds of delay considered problematic
(default: 30)
- error_rate_threshold: percentage of sessions with errors considered
problematic (default: 0.1)
- navigation_threshold: percentage of sessions visiting a page below
which it's considered underused (default: 0.2)
- rapid_change_window: seconds within which multiple changes indicate
confusion (default: 10)
- rapid_change_count: number of changes within window to flag as
confusion (default: 5)}
}
\value{
A tibble of class "bid_issues_tbl" with structured issue metadata
}
\description{
Preferred modern interface for telemetry analysis. Returns a clean tibble
of identified issues without the legacy list structure. Use this function
for new workflows that don't need backward compatibility.

\strong{OpenTelemetry Support}: For Shiny >= 1.12.0 applications using native
OpenTelemetry, pass the path to OTLP JSON exports or OTEL-formatted
SQLite databases. Format is auto-detected. See
\code{vignette("otel-integration")} for complete setup guide.
}
\examples{
\dontrun{
# Works with shiny.telemetry
issues <- bid_telemetry("telemetry.sqlite")

# Works with Shiny OpenTelemetry (1.12+)
issues <- bid_telemetry("otel_spans.json")

# Same analysis workflow for both
high_priority <- issues[issues$severity \%in\% c("critical", "high"), ]

# Use DBI connection directly
con <- DBI::dbConnect(RSQLite::SQLite(), "telemetry.sqlite")
issues <- bid_telemetry(con, table_name = "my_events")
DBI::dbDisconnect(con)

# Use with bridges for BID workflow
top_issue <- issues[1, ]
notice <- bid_notice_issue(top_issue, previous_stage = interpret_stage)
}
}
