% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R, R/mock_bids.R
\name{transform_files}
\alias{transform_files}
\alias{transform_files.bids_project}
\alias{transform_files.mock_bids_project}
\title{Query Transform Files from a BIDS Project}
\usage{
transform_files(
  x,
  subid = ".*",
  session = ".*",
  from = ".*",
  to = ".*",
  mode = ".*",
  kind = ".*",
  full_path = TRUE,
  ...
)

\method{transform_files}{bids_project}(
  x,
  subid = ".*",
  session = ".*",
  from = ".*",
  to = ".*",
  mode = ".*",
  kind = ".*",
  full_path = TRUE,
  ...
)

\method{transform_files}{mock_bids_project}(
  x,
  subid = ".*",
  session = ".*",
  from = ".*",
  to = ".*",
  mode = ".*",
  kind = ".*",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} or \code{mock_bids_project} object.}

\item{subid}{Regex pattern to match subject IDs (without "sub-" prefix).
Default \code{".*"} matches all subjects.}

\item{session}{Regex pattern to match session IDs (without "ses-" prefix).
Default \code{".*"} matches all sessions.}

\item{from}{Regex pattern to match source space (the "from" BIDS entity).
Common values: "T1w", "boldref", "fsnative". Default \code{".*"} matches all.}

\item{to}{Regex pattern to match target space (the "to" BIDS entity).
Common values: "MNI152NLin2009cAsym", "T1w", "fsnative". Default \code{".*"} matches all.}

\item{mode}{Regex pattern to match transform mode entity. Default \code{".*"}.}

\item{kind}{Transform type: \code{"xfm"}, \code{"warp"}, \code{"affine"}, or \code{".*"} for all types.
Default \code{".*"} matches all transform types.}

\item{full_path}{Logical. If \code{TRUE} (default), return absolute file paths.
If \code{FALSE}, return paths relative to project root.}

\item{...}{Additional arguments passed to \code{search_files}.}
}
\value{
Character vector of file paths matching the criteria, or \code{NULL} if
no matching files are found.
}
\description{
Retrieves paths to transformation files (xfm, warp, affine) from a BIDS project,
optionally filtered by source and target coordinate space. Transform files are
typically found in fMRIPrep derivatives and encode spatial transformations
between different coordinate spaces (e.g., T1w to MNI, boldref to T1w).
}
\examples{
\donttest{
# Get all transform files
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep = TRUE)

  # All transforms
  all_xfms <- transform_files(proj)

  # Transforms from T1w to MNI space
  t1_to_mni <- transform_files(proj, from = "T1w", to = "MNI152")

  # All transforms for a specific subject
  sub01_xfms <- transform_files(proj, subid = "01")

  # Clean up
  unlink(ds_path, recursive = TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
