% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidsio.R
\name{read_func_scans.bids_project}
\alias{read_func_scans.bids_project}
\title{Read in a set of four-dimensional functional scans}
\usage{
read_func_scans.bids_project(
  x,
  mask,
  mode = c("normal", "bigvec"),
  subid = "^sub-.*",
  task = ".*",
  run = ".*",
  modality = "bold",
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object}

\item{mask}{A brain mask of type \code{LogicalNeuroVol}}

\item{mode}{The file mode: 'normal' for in-memory files or 'bigvec' for on-disk files}

\item{subid}{One or more subject IDs (regex)}

\item{task}{An optional task regex}

\item{run}{An optional run regex}

\item{modality}{The image modality (usually "bold")}

\item{...}{Extra arguments passed to \code{neuroim2::read_vec}}
}
\value{
An instance of type \code{NeuroVec}
}
\description{
Read in a set of four-dimensional functional scans
}
\examples{
\donttest{
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep=TRUE)
  mask <- brain_mask(proj, subid="01")
  vec <- read_func_scans.bids_project(proj, mask,
                                     subid="01",
                                     task="balloonanalogrisktask",
                                     run="01")
  unlink(ds_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires derivatives dataset: ", e$message)
})
}
}
