% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidsio.R
\name{read_confounds.bids_project}
\alias{read_confounds.bids_project}
\title{Read confound files}
\usage{
\method{read_confounds}{bids_project}(
  x,
  subid = ".*",
  task = ".*",
  session = ".*",
  run = ".*",
  cvars = DEFAULT_CVARS,
  npcs = -1,
  perc_var = -1,
  nest = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object}

\item{subid}{Subject ID regex}

\item{task}{Task regex}

\item{session}{Session regex}

\item{run}{Run regex. If the run identifier cannot be extracted from
the filename, the run value defaults to "1".}

\item{cvars}{The names of the confound variables to select. Defaults to \code{DEFAULT_CVARS}.
Canonical names such as \code{"csf"} are automatically mapped to any
matching column names found in the dataset using \code{CVARS_ALIASES}.
You can also pass convenience sets from \code{confound_set()}, e.g.,
\code{confound_set("motion24")}, or wildcard patterns like
\code{"cosine_*"}, \code{"motion_outlier_*"}, or \code{"a_comp_cor_*[6]"}.}

\item{npcs}{Perform PCA reduction on confounds and return \code{npcs} PCs.}

\item{perc_var}{Perform PCA reduction to retain \code{perc_var}\% variance.}

\item{nest}{If TRUE, nests confound tables by subject/task/session/run.}

\item{...}{Additional arguments (not currently used)}
}
\value{
A \code{bids_confounds} tibble (nested if nest=TRUE) with identifier columns
for participant_id, task, session, and run. When PCA is requested, the
object includes a \code{pca} attribute with per-run loadings and variance used
by \code{plot()}.
}
\description{
Reads in fmriprep confound tables for one or more subjects.
}
\examples{
\donttest{
# Try to load a BIDS project with fMRIPrep derivatives
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep=TRUE)
  
  # Read confounds with canonical names (automatically resolve to actual columns)
  conf <- read_confounds(proj, cvars = c("csf", "framewise_displacement"))

  # Use convenience sets
  conf_36p <- read_confounds(proj, cvars = confound_set("36p"))
  conf_compcor6 <- read_confounds(proj, cvars = confound_set("acompcor", n = 6))
  
  # Read confounds for specific subjects and tasks
  conf_sub <- read_confounds(proj, subid="01", task="balloonanalogrisktask")
  
  # Get confounds as flat tibble
  conf_flat <- read_confounds(proj, nest=FALSE)
  
  # Clean up
  unlink(ds_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires derivatives dataset with confounds: ", e$message)
})
}
}
