% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/events.R, R/mock_bids.R
\name{event_files}
\alias{event_files}
\alias{event_files.bids_project}
\alias{event_files.mock_bids_project}
\title{Get event files from a BIDS project}
\usage{
event_files(x, ...)

\method{event_files}{bids_project}(
  x,
  subid = ".*",
  task = ".*",
  run = ".*",
  session = ".*",
  full_path = TRUE,
  ...
)

\method{event_files}{mock_bids_project}(
  x,
  subid = ".*",
  task = ".*",
  run = ".*",
  session = ".*",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A mock_bids_project object}

\item{...}{Additional arguments passed to internal functions}

\item{subid}{Regex to match subject IDs (default: ".*")}

\item{task}{Regex to match tasks (default: ".*")}

\item{run}{Regex to match runs (default: ".*")}

\item{session}{Regex to match sessions (default: ".*")}

\item{full_path}{If TRUE, return full paths of files (default: TRUE)}
}
\value{
A character vector of file paths to event files matching the specified criteria.
If no matching files are found, returns NULL.

A character vector of file paths to event files. If no matching files are found, returns an empty character vector.
}
\description{
This function retrieves a vector of event files (events.tsv) from a BIDS project
that match specified criteria. Event files in BIDS contain trial information for
task-based functional MRI data, including onset times, durations, and trial types.

Finds event files matching the given subject, task, run, and session criteria.
}
\examples{
\donttest{
# Get all event files from a BIDS project
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  event_files(proj)
  
  # Get event files for specific subjects and tasks
  if (length(participants(proj)) > 0) {
    event_files(proj, subid=participants(proj)[1], task="balloonanalogrisktask")
  }
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
\donttest{
# Get event files for a specific subject and task
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  x <- bids_project(ds001_path)
  files <- event_files(x, subid="01", task="balloonanalogrisktask")
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
