% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCFunctions.R
\name{getEstimates}
\alias{getEstimates}
\title{getEstimates}
\usage{
getEstimates(
  analyses_list,
  add_parameters = NULL,
  point_estimator = "median",
  alpha_level = 0.05
)
}
\arguments{
\item{analyses_list}{An object of class \code{analysis_list},
as created with \code{\link[bhmbasket]{performAnalyses}}}

\item{add_parameters}{A vector of strings naming additional parameters
from the Bayesian hierarchical models, e.g. \code{c('mu', 'tau')}.
If \code{NULL}, no additional parameters will be evaluated,
Default: \code{NULL}}

\item{point_estimator}{A string indicating the type of estimator used for calculation of
bias and MSE. Must be one of \code{'median'} or \code{'mean'}}

\item{alpha_level}{A numeric in (0, 1) for the level of the credible interval.
Only values corresponding to quantiles saved in \code{\link[bhmbasket]{performAnalyses}}
will work, Default: \code{0.05}}
}
\value{
A named list of matrices of estimates of response rates and credible intervals.
Estimates of bias and MSE are included for response rate estimates of simulated trials.
}
\description{
This function calculates the point estimates and credible intervals per cohort,
as well as estimates of the biases and the mean squared errors of the point estimates per cohort.
}
\details{
Bias and MSE will only be calculated for response rate estimates of simulated trials.
For additional parameters, bias and MSE will not be calculated.

Possible additional parameters are for the Bayesian hierarchical models are
\code{c('mu', 'tau')} for \code{'berry'}, \code{'exnex'}, and \code{'exnex_adj'}.
The latter two models can also access the posterior weights
\code{paste0("w_", seq_len(n_cohorts))}.
}
\examples{
  scenarios_list <- simulateScenarios(
    n_subjects_list     = list(c(10, 20, 30)),
    response_rates_list = list(c(0.1, 0.2, 3)),
    n_trials            = 10)

  analyses_list <- performAnalyses(
    scenario_list       = scenarios_list,
    target_rates        = c(0.1, 0.1, 0.1),
    calc_differences    = matrix(c(3, 2, 2, 1), ncol = 2),
    n_mcmc_iterations   = 100)

  getEstimates(analyses_list)
  getEstimates(analyses_list   = analyses_list,
               add_parameters  = c("mu", "tau", "w_1", "w_2", "w_3"),
               point_estimator = "mean",
               alpha_level     = 0.1)

  outcome <- createTrial(
    n_subjects          = c(10, 20, 30),
    n_responders        = c( 1,  2,  3))

  outcome_analysis <- performAnalyses(
    scenario_list       = outcome,
    target_rates        = c(0.1, 0.1, 0.1),
    n_mcmc_iterations   = 100)

  getEstimates(outcome_analysis)
  getEstimates(analyses_list  = outcome_analysis,
               add_parameters = c("mu", "w_1", "w_2", "w_3"))
}
\seealso{
\code{\link[bhmbasket]{createTrial}}
\code{\link[bhmbasket]{simulateScenarios}}
\code{\link[bhmbasket]{performAnalyses}}
}
\author{
Stephan Wojciekowski
}
