% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect_methods.R
\name{summary.lm_betaselect}
\alias{summary.lm_betaselect}
\alias{print.summary.lm_betaselect}
\title{Summary of an
'lm_betaselect'-Class Object}
\usage{
\method{summary}{lm_betaselect}(
  object,
  correlation = FALSE,
  symbolic.cor = FALSE,
  se_method = c("boot", "bootstrap", "t", "lm", "ls"),
  ci = TRUE,
  level = 0.95,
  boot_type = c("perc", "bc"),
  boot_pvalue_type = c("asymmetric", "norm"),
  type = c("beta", "standardized", "raw", "unstandardized"),
  print_raw = c("none", "before_ci", "after_ci"),
  ...
)

\method{print}{summary.lm_betaselect}(
  x,
  est_digits = 3,
  symbolic.cor = x$symbolic.cor,
  signif.stars = getOption("show.signif.stars"),
  tz_digits = 3,
  pvalue_less_than = 0.001,
  ...
)
}
\arguments{
\item{object}{The output of
\code{\link[=lm_betaselect]{lm_betaselect()}}.}

\item{correlation}{If \code{TRUE}, the
correlation matrix of the estimates
will be returned. The same argument
in \code{\link[stats:summary.lm]{stats::summary.lm()}}. Default
is \code{FALSE}.}

\item{symbolic.cor}{If \code{TRUE},
correlations are printed in symbolic
form as in \code{\link[stats:summary.lm]{stats::summary.lm()}}.
Default is \code{FALSE}.}

\item{se_method}{The method used to
compute the standard errors and
confidence intervals (if requested).
If bootstrapping was
requested when calling
\code{\link[=lm_betaselect]{lm_betaselect()}} and this argument
is set to \code{"bootstrap"} or \code{"boot"},
the bootstrap standard errors are
returned. If bootstrapping
was not requested or if this argument
is set to \code{"t"}, \code{"lm"}, or \code{"ls"},
then the usual \code{lm}
standard errors are
returned.
Default is \code{"boot"}.}

\item{ci}{Logical. Whether
confidence intervals are computed.
Default is \code{TRUE}.}

\item{level}{The level of confidence,
default is .95, returning the 95\%
confidence interval.}

\item{boot_type}{The type of
bootstrap confidence intervals,
if requested.
Currently, it supports \code{"perc"},
percentile bootstrap confidence
intervals, and \code{"bc"}, bias-corrected
bootstrap confidence interval.}

\item{boot_pvalue_type}{The type
of \emph{p}-values if \code{se_method} is
\code{"boot"} or \code{"bootstrap"}. If \code{"norm"},
then the \emph{z} score is used to compute
the \emph{p}-value using a
standard normal distribution.
If \code{"asymmetric"}, the default, then
the method presented in
Asparouhov and Muthén (2021) is used
to compute the \emph{p}-value based on the
bootstrap distribution.}

\item{type}{String. If
\code{"unstandardized"} or \code{"raw"}, the
output \emph{before} standardization
are used If \code{"beta"} or
\code{"standardized"}, then the
output \emph{after} selected
variables standardized are returned.
Default is \code{"beta"}.}

\item{print_raw}{Control whether
the estimates before selected
standardization are printed when
\code{type} is \code{"beta"} or \code{"standardized"}.
If \code{"none"}, the default, then it
will not be printed. If set to \code{"before_ci"}
and \code{ci} is \code{TRUE}, then will be
inserted to the left of the confidence
intervals. If set to "after_ci"\code{and}ci\code{is}TRUE\verb{, then will be printed to the right of the confidence intervals. If }ci\code{is}FALSE`, then will
be printed to the right of the
standardized estimates.}

\item{...}{Additional arguments
passed to other methods.}

\item{x}{The output of
\code{\link[=summary.lm_betaselect]{summary.lm_betaselect()}}.}

\item{est_digits}{The number of
digits after the decimal to be
displayed for the coefficient
estimates, their standard errors, and
confidence intervals (if present).
Note that the values will be rounded
to this number of digits before
printing. If all digits at this
position are zero for all values, the
values may be displayed with fewer
digits. Note that the coefficient
table is printed by
\code{\link[stats:printCoefmat]{stats::printCoefmat()}}. If some
numbers are vary large, the number of
digits after the decimal may be
smaller than \code{est_digits} due to a
limit on the column width. This value
also determines the number of digits
for displayed R-squared.}

\item{signif.stars}{Whether "stars"
(asterisks) are printed to denote
the level of significance achieved
for each coefficient. Default is
\code{TRUE}.}

\item{tz_digits}{The number of digits
after the decimal to be displayed for
the \emph{t} or similar statistic (in the
column \code{"t value"} or \code{"z value"}).
This value also determines the number
of digits for the \emph{F} statistic for
the R-squared.}

\item{pvalue_less_than}{If a
\emph{p}-value is less than this value, it
will be displayed with \verb{"<(this value)".} For example, if
\code{pvalue_less_than} is .001, the
default, \emph{p}-values less than .001
will be displayed as \verb{<.001}. This
value also determines the printout of
the \emph{p}-value of the \emph{F} statistic.
(This argument does what \code{eps.Pvalue}
does in \code{\link[stats:printCoefmat]{stats::printCoefmat()}}.)}
}
\value{
It returns an object of class
\code{summary.lm_betaselect}, which is
similar to the output of
\code{\link[stats:summary.lm]{stats::summary.lm()}}, with additional
information on the standardization
and bootstrapping, if requested.

The \code{print}-method of
\code{summary.lm_betaselect} is called
for its side effect. The object \code{x}
is returned invisibly.
}
\description{
The \code{summary} method
for \code{lm_betaselect}-class objects.
}
\details{
By default, it returns a
\code{summary.lm_betaselect}-class object
for the results with selected variables
standardized. By setting \code{type} to
\code{"raw"} or \code{"unstandardized"}, it
return the summary for the results
\emph{before} standardization.

The \code{print} method of
\code{summary.lm_betaselect}-class objects
is adapted from
\code{\link[stdmod:print.summary.std_selected]{stdmod::print.summary.std_selected()}}.
}
\examples{

data(data_test_mod_cat)

# bootstrap should be set to 2000 or 5000 in real studies
lm_beta_x <- lm_betaselect(dv ~ iv*mod + cov1 + cat1,
                           data = data_test_mod_cat,
                           to_standardize = "iv",
                           do_boot = TRUE,
                           bootstrap = 100,
                           iseed = 1234)

summary(lm_beta_x)
summary(lm_beta_x, ci = TRUE)
summary(lm_beta_x, boot_pvalue_type = "norm")
summary(lm_beta_x, type = "raw")

}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=lm_betaselect]{lm_betaselect()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
