% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.brs}
\alias{predict.brs}
\title{Predict from a fitted model}
\usage{
\method{predict}{brs}(
  object,
  newdata = NULL,
  type = c("response", "link", "precision", "variance", "quantile"),
  at = 0.5,
  ...
)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{newdata}{Optional data frame for prediction.}

\item{type}{Prediction type: \code{"response"} (default),
\code{"link"}, \code{"precision"}, \code{"variance"}, or
\code{"quantile"}.}

\item{at}{Numeric vector of probabilities for quantile
predictions (default 0.5).}

\item{...}{Currently ignored.}
}
\value{
Numeric vector or matrix.
}
\description{
Predict from a fitted model
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
head(predict(fit))
head(predict(fit, type = "precision"))
newdat <- data.frame(x1 = c(1, 2))
predict(fit, newdata = newdat)
}

}
\seealso{
\code{\link{brs}}, \code{\link{fitted.brs}},
  \code{\link{brs_predict_scoreprob}}
}
