% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{brs_repar}
\alias{brs_repar}
\title{Reparameterize (mu, phi) into beta shape parameters}
\usage{
brs_repar(mu, phi, repar = 2L)
}
\arguments{
\item{mu}{Numeric vector of mean values in \eqn{(0, 1)}.}

\item{phi}{Numeric vector (or scalar) of dispersion values.}

\item{repar}{Integer (0, 1, or 2) selecting the scheme.}
}
\value{
A \code{data.frame} with columns \code{shape1} and
  \code{shape2}.
}
\description{
Converts a mean–dispersion pair \eqn{(\mu, \phi)} to the shape
parameters \eqn{(a, b)} of the beta distribution under one of
three reparameterization schemes.
}
\details{
The three schemes are:
\describe{
  \item{\code{repar = 0}}{Direct: \eqn{a = \mu,\; b = \phi}.}
  \item{\code{repar = 1}}{Ferrari–Cribari-Neto:
    \eqn{a = \mu\phi,\; b = (1 - \mu)\phi}, where \eqn{\phi}
    acts as a precision parameter.}
  \item{\code{repar = 2}}{Mean–variance:
    \eqn{a = \mu(1-\phi)/\phi,\; b = (1-\mu)(1-\phi)/\phi},
    where \eqn{\phi \in (0,1)} is analogous to a coefficient
    of variation.}
}
}
\examples{
brs_repar(mu = 0.5, phi = 0.2, repar = 2)

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
