% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{hurlbert}
\alias{hurlbert}
\title{Hurlbert's Expected Number of Species}
\usage{
hurlbert(taxon, count, n = 100L)
}
\arguments{
\item{taxon}{character vector containing taxa}

\item{count}{numeric vector containing counts}

\item{n}{number of individuals in a standard sample}
}
\value{
expected number of species in a sample of \code{n} individuals
}
\description{
The expected number of species in a sample of \code{n} individuals:
}
\examples{
     hurlbert(
         taxon = c("Euspira pulchella", "Nephtys cirrosa"),
         count = c(4, 6),
         n = 8
     )

}
\references{
Hurlbert, S.H., 1971. The Nonconcept of Species Diversity:
     A Critique and Alternative Parameters. Ecology 52:577-586.
}
