% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimInstanceBatch.R
\name{OptimInstanceBatch}
\alias{OptimInstanceBatch}
\title{Optimization Instance for Batch Optimization}
\description{
The \code{OptimInstanceBatch} specifies an optimization problem for an \link{OptimizerBatch}.
The function \code{\link[=oi]{oi()}} creates an \link{OptimInstanceAsyncSingleCrit} or \link{OptimInstanceAsyncMultiCrit}.
}
\seealso{
\code{\link[=oi]{oi()}}, \link{OptimInstanceBatchSingleCrit}, \link{OptimInstanceBatchMultiCrit}
}
\section{Super classes}{
\code{\link[bbotk:EvalInstance]{bbotk::EvalInstance}} -> \code{\link[bbotk:OptimInstance]{bbotk::OptimInstance}} -> \code{OptimInstanceBatch}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{objective_multiplicator}}{(\code{integer()}).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{result}}{(\link[data.table:data.table]{data.table::data.table})\cr
Get result}

\item{\code{result_x_search_space}}{(\link[data.table:data.table]{data.table::data.table})\cr
x part of the result in the \emph{search space}.}

\item{\code{result_x_domain}}{(\code{list()})\cr
(transformed) x part of the result in the \emph{domain space} of the objective.}

\item{\code{result_y}}{(\code{numeric()})\cr
Optimal outcome.}

\item{\code{is_terminated}}{(\code{logical(1)}).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimInstanceBatch-new}{\code{OptimInstanceBatch$new()}}
\item \href{#method-OptimInstanceBatch-eval_batch}{\code{OptimInstanceBatch$eval_batch()}}
\item \href{#method-OptimInstanceBatch-objective_function}{\code{OptimInstanceBatch$objective_function()}}
\item \href{#method-OptimInstanceBatch-clone}{\code{OptimInstanceBatch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="EvalInstance" data-id="format"><a href='../../bbotk/html/EvalInstance.html#method-EvalInstance-format'><code>bbotk::EvalInstance$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="assign_result"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-assign_result'><code>bbotk::OptimInstance$assign_result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="clear"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-clear'><code>bbotk::OptimInstance$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="OptimInstance" data-id="print"><a href='../../bbotk/html/OptimInstance.html#method-OptimInstance-print'><code>bbotk::OptimInstance$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceBatch-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceBatch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceBatch$new(
  objective,
  search_space = NULL,
  terminator,
  check_values = TRUE,
  callbacks = NULL,
  archive = NULL,
  label = NA_character_,
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{objective}}{(\link{Objective})\cr
Objective function.}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{\code{terminator}}{\link{Terminator}\cr
Termination criterion.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}

\item{\code{callbacks}}{(list of \link[mlr3misc:Callback]{mlr3misc::Callback})\cr
List of callbacks.}

\item{\code{archive}}{(\link{Archive}).}

\item{\code{label}}{(\code{character(1)})\cr
Label for this object.
Can be used in tables, plot and text output instead of the ID.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceBatch-eval_batch"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceBatch-eval_batch}{}}}
\subsection{Method \code{eval_batch()}}{
Evaluates all input values in \code{xdt} by calling
the \link{Objective}. Applies possible transformations to the input values
and writes the results to the \link{Archive}.

Before each batch-evaluation, the \link{Terminator} is checked, and if it
is positive, an exception of class \code{terminated_error} is raised. This
function should be internally called by the \link{Optimizer}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceBatch$eval_batch(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{data.table::data.table()})\cr
x values as \code{data.table()} with one point per row. Contains the value in
the \emph{search space} of the \link{OptimInstance} object. Can contain additional
columns for extra information.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceBatch-objective_function"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceBatch-objective_function}{}}}
\subsection{Method \code{objective_function()}}{
Evaluates (untransformed) points of only numeric values. Returns a
numeric scalar for single-crit or a numeric vector for multi-crit. The
return value(s) are negated if the measure is maximized. Internally,
\verb{$eval_batch()} is called with a single row. This function serves as a
objective function for optimizers of numeric spaces - which should always
be minimized.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceBatch$objective_function(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{numeric()})\cr
Untransformed points.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Objective value as \code{numeric(1)}, negated for maximization problems.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimInstanceBatch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimInstanceBatch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimInstanceBatch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
