% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_utils.R
\name{aw_scores}
\alias{aw_scores}
\title{Compute AIPW/doubly robust scores.}
\usage{
aw_scores(yobs, ws, balwts, K, mu_hat = NULL)
}
\arguments{
\item{yobs}{Numeric vector. Observed rewards. Must not contain NA values.}

\item{ws}{Integer vector. Pulled arms. Must not contain NA values. Length must match \code{yobs}.}

\item{balwts}{Numeric matrix. Inverse probability score \eqn{1[W_t=w]/e_t(w)} of pulling arms, shape \code{[A, K]}, where \code{A} is the number of observations and \code{K} is the number of arms. Must not contain NA values.}

\item{K}{Integer. Number of arms. Must be a positive integer.}

\item{mu_hat}{Optional numeric matrix. Plug-in estimator of arm outcomes, shape \code{[A, K]}, or \code{NULL}. Must not contain NA values if provided.}
}
\value{
Numeric matrix. AIPW scores, shape \code{[A, K]}.
}
\description{
Computes AIPW/doubly robust scores based on observed rewards, pulled arms, and inverse
probability scores. If \code{mu_hat} is provided, compute AIPW scores, otherwise compute IPW scores.
}
\examples{
aw_scores(yobs = c(0.5, 1, 0, 1.5),
          ws = c(1, 2, 2, 3),
          balwts = matrix(c(0.5, 2, 1, 0.5,
                            1, 1.5, 0.5, 1.5,
                            2, 1.5, 0.5, 1),
                            ncol = 3),
          K = 3,
          mu_hat = matrix(c(0.5, 0.8, 0.6, 0.3,
                            0.9, 0.2, 0.5, 0.7,
                            0.4, 0.8, 0.2, 0.6),
                            ncol = 3))

}
