% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop.R
\name{new_class}
\alias{new_class}
\title{Define a new class}
\usage{
new_class(
  ...,
  env = new.env(parent = parent.frame()),
  class_name = NULL,
  empty_class = FALSE
)
}
\arguments{
\item{...}{Environments. Parent class environments.}

\item{env}{Environment. The new class environment.}

\item{class_name}{Name of the new class.}

\item{empty_class}{Boolean. Whether to create an empty class. This should only
be used when you don't want to inherited from \link{BASE}, or you want to define
your own base object class. Will be ignored if \code{...} is not empty. If \code{...}
is empty and \code{empty_class == FALSE}, \link{BASE} will be used as the parent class.}
}
\value{
A class environment with S3 class "bandicoot_oop".
}
\description{
This function declare a new class, and copies attributes and methods from
parent classes.
}
\details{
Parents can be provided in \code{...}, where methods and attributes will be
overrided by the left classes because \code{bandicoot} does not support dynamic
dispatch at the moment. However, this behaviour usually aligns with the method
resolution order defined by the C3 algorithm used in Python.
If \code{...} is empty and \code{empty_class == FALSE},
\link{BASE} will be used as the parent class.
}
\examples{
MYCLASS <- new_class(class_name = "MYCLASS")
MYCLASS
names(MYCLASS)

# Inhert from BASE class
TEST <- new_class(BASE, class_name = "TEST")
TEST
names(TEST)

}
