% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_BASE.R
\name{BASE$..init..}
\alias{BASE$..init..}
\title{Initialization method}
\arguments{
\item{...}{Ignored by \code{BASE}, but user can define their owns.}
}
\value{
Return the object itself.
}
\description{
This function will be called after an instance is built. User
could override this function in derived class.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{BASE$..init..(...)
}\if{html}{\out{</div>}}
}
}
\examples{

BASE$..init..

# Inherit from BASE
TEST <- new_class(BASE, class_name = "TEST")

# Override the `..init..` method
register_method(TEST, ..init.. = function(a) {self$x <- a})

# Build a `TEST` instance
test <- TEST$instantiate(a = 2)

test$x
}
