% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_create}
\alias{am_create}
\title{Create a new Automerge document}
\usage{
am_create(actor_id = NULL)
}
\arguments{
\item{actor_id}{Optional actor ID. Can be:
\itemize{
\item \code{NULL} (default) - Generate random actor ID
\item Character string - Hex-encoded actor ID
\item Raw vector - Binary actor ID bytes
}}
}
\value{
An external pointer to the Automerge document with class
\code{c("am_doc", "automerge")}.
}
\description{
Creates a new Automerge document with an optional custom actor ID.
If no actor ID is provided, a random one is generated.
}
\section{Thread Safety}{

The automerge package is NOT thread-safe. Do not access the same document
from multiple R threads concurrently. Each thread should create its own
document with \code{am_create()} and synchronize changes via
\verb{am_sync_*()} functions after thread completion.
}

\examples{
# Create document with random actor ID
doc1 <- am_create()
doc1

# Create with custom hex actor ID
doc2 <- am_create("0123456789abcdef0123456789abcdef")

# Create with raw bytes actor ID
actor_bytes <- as.raw(1:16)
doc3 <- am_create(actor_bytes)

am_close(doc1)
am_close(doc2)
am_close(doc3)

}
