% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_actor_id}
\alias{am_change_actor_id}
\title{Get the actor ID of a change}
\usage{
am_change_actor_id(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}} or
\code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A raw vector containing the actor ID bytes
}
\description{
Returns the actor ID of the peer that created the change.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add key")

history <- am_get_changes(doc)
actor <- am_change_actor_id(history[[1]])
actor

# Should match the document's actor
identical(actor, am_get_actor(doc))  # TRUE

am_close(doc)

}
