% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit.R
\name{next_local_solar_eclipse}
\alias{next_local_solar_eclipse}
\title{Search for the next local solar eclipse}
\usage{
next_local_solar_eclipse(prev_eclipse_time, latitude, longitude)
}
\arguments{
\item{prev_eclipse_time}{A \code{POSIXct} time near a previous eclipse peak.}

\item{latitude}{Latitude of the observer in degrees (-90 to 90).}

\item{longitude}{Longitude of the observer in degrees (-180 to 180).}
}
\value{
A list with the same structure as \code{search_local_solar_eclipse}.
}
\description{
Finds the next solar eclipse in a series at a specific location.
Typically, you pass the \code{peak} value from a previous
\code{search_local_solar_eclipse} or \code{next_local_solar_eclipse} call.
}
\examples{
start <- as.POSIXct("2025-01-01", tz = "UTC")
eclipse1 <- search_local_solar_eclipse(start, 37.77, -122.41)
eclipse2 <- next_local_solar_eclipse(eclipse1$peak$time, 37.77, -122.41)
}
