% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_additional.R
\name{anova_alpha_lattice}
\alias{anova_alpha_lattice}
\title{Alpha Lattice Design ANOVA}
\usage{
anova_alpha_lattice(
  data,
  response,
  genotype,
  replication,
  block,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{response}{Name of response variable}

\item{genotype}{Name of genotype column}

\item{replication}{Name of replication column}

\item{block}{Name of incomplete block column (nested within replication)}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA results
}
\description{
Performs ANOVA for Alpha Lattice (Resolvable Incomplete Block) Design.
}
\examples{
data <- expand.grid(rep = 1:2, block = 1:5, entry = 1:4)
data$genotype <- paste0("G", 1:nrow(data))
data$yield <- rnorm(nrow(data), 1200, 150)

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
