% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{feed_intake}
\alias{feed_intake}
\title{Daily feed intake}
\format{
A tibble with 270 rows and 4 columns:
\describe{
 \item{date}{date; date of data recording.}
 \item{tank}{factor; rearing tank identifier.}
 \item{daily_feed_intake}{numeric; daily feed intake in gram per fish.}
 \item{cumulative_feed_intake}{numeric; cumulatic feed intake in gram per 
 fish.}
}
}
\description{
This dataset contains daily feed intake data from a feeding trial with 
Atlantic salmon (Salmo salar).
The original dataset ("FeedIntake") was published by Liland et al. (2024) 
and is from the first out of two trials ("Trial A"). Alterations to the 
original data structure were done by 1) converting the double-row column 
names into single-row column names, 2) shortening the column names, and 3) 
converting the table into long format by moving the tank IDs into a separate 
column. NA values have been replaced by the recalculated feed intakes for 
the respective day.
}
\examples{
feed_intake

}
\references{
Liland, N., Rønnestad, I., Azevedo, M., Lai, F., Oulie, F., 
Conceição, L., Soares, F. (2024): Dataset on the performance of Atlantic 
salmon (Salmo salar) reared at different dissolved oxygen levels under 
experimental conditions. Data in Brief 57, 110983. 
https://doi.org/10.1016/j.dib.2024.110983
}
\keyword{datasets}
