% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries_enhanced.R
\name{anki_plot_monte_carlo}
\alias{anki_plot_monte_carlo}
\title{Plot Monte Carlo Forecast}
\usage{
anki_plot_monte_carlo(
  mc_forecast,
  show_bands = c("95", "80"),
  show_simulations = 20,
  cumulative = FALSE
)
}
\arguments{
\item{mc_forecast}{Output from anki_forecast_monte_carlo()}

\item{show_bands}{Confidence bands to show: "95", "80", "50", or combinations}

\item{show_simulations}{Number of individual simulations to overlay (0 for none)}

\item{cumulative}{Plot cumulative reviews instead of daily}
}
\value{
A ggplot2 object
}
\description{
Visualize Monte Carlo forecast with confidence bands.
}
\examples{
\dontrun{
mc <- anki_forecast_monte_carlo(days_ahead = 30)
anki_plot_monte_carlo(mc)
anki_plot_monte_carlo(mc, cumulative = TRUE)
}
}
