% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burnout_quality.R
\name{anki_burnout_detection}
\alias{anki_burnout_detection}
\title{Detect Burnout Warning Signs}
\usage{
anki_burnout_detection(
  path = NULL,
  profile = NULL,
  days = 30,
  baseline_days = 90
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{days}{Number of days to analyze (default 30)}

\item{baseline_days}{Days to use as baseline for comparison (default 90)}
}
\value{
A list with burnout indicators and recommendations
}
\description{
Analyzes study patterns to detect potential burnout indicators:
declining retention, increasing response time, shorter sessions,
more "Again" presses, decreased consistency.
}
\examples{
\dontrun{
burnout <- anki_burnout_detection()
burnout$risk_level
burnout$indicators
}
}
