ammiBayes <- function(Y=Y, Gen=Gen, Env=Env, Rep=Rep, M=NULL, algorithm="AMMI", iterations=3000, jump=2, burn=500,
											Var.error=0.5, Var.env=0.5, Var.gen=0.5, Var.a=0.5, Var.d=0.5,
											chains=2){

  if(algorithm!="AMMI" & is.null(M)) stop(cat("For the algorithm", algorithm, "the matrix M should be defined.", "\n"))

	if(chains < 2) stop("The minimum number of chains should be 2.")

	if(!is.factor(Gen)) stop("Gen is not a factor.")
	if(!is.factor(Rep)) stop("Rep is not a factor.")
	if(!is.factor(Env)) stop("Env is not a factor.")
	if(nlevels(Env)<4) stop("Env must have more than 3 environments.")


	if(algorithm!="AMMI"){
		if(nlevels(Gen)!=nrow(M)) stop(cat("The number of Genotypes should be the same of the number of rows of the matrix M.", "\n"))
	}

	cores <- detectCores()

	niter <- iterations*jump + burn

	osp <- Sys.info()['sysname']

  FUN <- match.fun(algorithm)

	if(osp!="Linux"){

	cat("Operational system detected:", osp, "\n")

	cat("The code will be run in serial mode. Only 1 core will be used.", "\n")

	output <- lapply(1:chains, function(cadeia){
											 outp <- FUN(Y=Y, Gen=Gen, Env=Env, Rep=Rep, M=M,
																					 iter=iterations, jump=jump,
																					 burn=burn, Var.error=Var.error,  Var.a = Var.a, 
																					 Var.d = Var.d, Var.env=Var.env, Var.gen=Var.gen,
																					 cadeia=cadeia)
											 return(outp)
											})
	cat("\n")
	}
	else {

	cat("Operational system detected:", osp, "\n")

	cat("The code will be run in parallel mode.", "\n")
  cat(cores, "cores were detected", "\n")


	output <- mclapply(1:chains, mc.cores=chains, function(cadeia){
											 outp <- FUN(Y=Y, Gen=Gen, Env=Env, Rep=Rep, M=M,
																					 iter=iterations, jump=jump,
																					 burn=burn, Var.error=Var.error,
																					 Var.env=Var.env, Var.gen=Var.gen,  
																					 Var.a = Var.a, Var.d = Var.d, cadeia=cadeia)
											 return(outp)
											})
	cat("\n")
	}

	info.iter <- list(iterations=iterations, jump=jump, burn=burn)
	rGen <- tapply(Gen,Gen,length)
	info.ammi <- list(Y=Y, nRep=nlevels(Rep), nGen=nlevels(Gen), lRep=levels(Rep),
										lGen=levels(Gen), envLevels=levels(Env))


	res <- list(output=output, info.iter=info.iter, rGen=rGen, info.ammi=info.ammi,
							algorithm=algorithm)

	class(res) <- "ammiBayes"
	return(res)
}

AMMI <- function(Y=NULL, Gen=NULL, Env=NULL, Rep=NULL, M=NULL, iter=iter, jump=jump,
												Var.error=0.5, Var.env=0.5, Var.gen=0.5,  Var.a = NULL, Var.d = NULL,
												burn=burn, cadeia=cadeia){

	x  <- Env
	x1 <- Rep
	z  <- Gen

	x  <- model.matrix(~x -1)
	x1 <- model.matrix(~x1 -1)
	z  <- model.matrix(~z -1)
	z1 <- model.matrix(~z*x -1)

	y  <- as.spam(Y)

	namb  <- ncol(x)
	ngen  <- ncol(z)
	nbloc <- ncol(x1)
	n <- nrow(z)
	s <- min(namb,ngen)-1

	ve  <- Var.error
	va  <- Var.env
	vge <- Var.gen

	A1 <- diag.spam(ngen)*(ve/va)
	A2 <- diag.spam(ngen*namb)*(vge/va)


	z1.sp <- as.spam(z1)
	z.sp <- as.spam(z) # Sparse matrix
	y.sp <- as.spam(y)
	x1.sp <- as.spam(x1)
	x.sp <- as.spam(x)

	y <- as.spam(y)

	x1x <- crossprod.spam(x1)
	sx1x <- solve(x1x)
	stx <- tcrossprod.spam(sx1x,x1.sp)
	beta <- stx%*%y


	tzz <- crossprod.spam(z.sp)
	tzzA1 <- tzz+A1
	tzs <- solve(tzzA1)
	tzsz <- tcrossprod.spam(tzs,z.sp)

	x1beta <- x1.sp%*%beta
	yx1beta <- y-x1beta
	g <- tzsz%*%yx1beta

	z1.sp <- z1.sp[,(ngen+namb+1):ncol(z1.sp)]


	pa1 <- crossprod.spam(z1.sp)
	pa1 <- pa1+A2
	part1 <- solve(pa1)
	part1z1 <- tcrossprod.spam(part1,z1.sp)


	zg <- z.sp%*%g

	part2 <- yx1beta-zg
	ge <- part1z1%*%part2

	gem  <- as.spam(matrix(0,ngen,namb))


	for(j in 1:namb)
	{
		if (j==1) gem[,j]=ge[j:ngen] else gem[,j]=ge[((j-1)*ngen+1):(ngen*j)] 
	}


	dec<- svd(gem)
	U  <- dec$u
	L  <- dec$d
	V  <- dec$v
	k  <- 1:s
	U  <- U[,1:s]
	L  <- L[1:s]
	V  <- V[,1:s]
	


	U.sp <- as.spam(U)
	L.sp <- as.spam(L)
	V.sp <- as.spam(V)

	cat("\n")

	cat(paste("Initializing chain", cadeia, sep=" "), "\n")

	cat("\n")


	for(i in 1:s)
	{

		zU <- c(z.sp%*%U.sp[,i])
		zUdiag <- diag.spam(zU)
		zUX <- zUdiag%*%x.sp
		z3 <- as.spam(zUX%*%V.sp[,i])

		z3z <- crossprod.spam(z3)
		z3solve <- solve(z3z)
		z3solvez3 <- tcrossprod.spam(z3solve,z3)	

		L[i] <- z3solvez3%*%part2

		if(i==1){

			xV  <- diag.spam(c(x.sp%*%V.sp[,i]))
			w1 <- xV%*%z.sp
			alpha <- crossprod.spam(w1,part2)

			Hg <- cbind(matrix(1,ngen,1),matrix(0,ngen,ngen-i))
			Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
			x.qr <- qr(Hg)
			Q <- qr.Q(x.qr)
			Q <- Q[,(i+1):ncol(Q)]

			Q <- as.spam(Q)
			alphaQ <- crossprod.spam(alpha, Q)
			AlphaQtQ <- tcrossprod.spam(alphaQ,Q)
			alphafim <- AlphaQtQ%*%alpha

			norm <- sqrt(c(alphafim))

			alphalinha <- crossprod.spam(Q,alpha)/c(norm)


			U.sp[,i] <- Q%*%alphalinha

			#     w2 <- zUX
			zu <- z.sp%*%U.sp[,i]
			zudiag <- diag.spam(c(zu))
			w2 <- zudiag%*%x.sp

			ipso <- crossprod.spam(w2,part2)

			He <- cbind(matrix(0,namb,(s)))
			He[1:s,i:ncol(He)] <- diag(s)
			x.qr <- qr(He)
			Q <- qr.Q(x.qr)
			Q <- as.matrix(Q[,i:ncol(Q)])
			Q <- as.spam(Q)


			norm1 <- crossprod.spam(ipso,Q) 
			norm2 <- tcrossprod.spam(norm1,Q)
			norm <- c(sqrt(norm2%*%ipso))

			ipsolinha <- crossprod.spam(Q,ipso)/norm

			V.sp[,i] <- Q%*%ipsolinha

		}
		if(i>1){

			xv <- x.sp%*%V.sp[,i]
			xvd <- diag.spam(c(xv))
			w1 <- xvd%*%z.sp


			alpha <- crossprod.spam(w1,part2)

			Hg <- cbind(matrix(1,ngen,1),U[,k<i],matrix(0,ngen,ngen-i))
			Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
			x.qr <- qr(Hg)
			Q <- qr.Q(x.qr)
			Q <- as.spam(Q)

			norm1 <- crossprod.spam(alpha,Q) 
			norm2 <- tcrossprod.spam(norm1,Q)
			norm <- c(sqrt(norm2%*%alpha))

			Q <- Q[,(i+1):ncol(Q)]

			qalpha <- crossprod.spam(Q,alpha)
			alphalinha <- qalpha/norm

			U.sp[,i] <- Q%*%alphalinha

			zU <- z.sp%*%U.sp[,i]    
			zUd <- diag.spam(c(zU))
			w2 <- zUd%*%x.sp

			ipso <- crossprod.spam(w2,part2)


			He <- cbind(V[,k<i],matrix(0,namb,(namb-i+1)))
			He[1:(namb-i+1),i:ncol(He)] <- diag(namb-i+1)
			x.qr <- qr(He)
			Q <- qr.Q(x.qr)
			Q <- as.spam(Q)


			norm1 <- crossprod.spam(ipso,Q)
			norm2 <- tcrossprod.spam(norm1,Q)
			norm <- c(sqrt(norm2%*%ipso))

			Q <- Q[,i:ncol(Q)]
			ipsolinha <- crossprod.spam(Q,ipso)/norm

			V.sp[,i] <- Q%*%ipsolinha
		}
	}

	zU <- z.sp%*%U.sp
	xV <- x.sp%*%V.sp
	zuv <- zU*xV
	AMMI <- zuv%*%L

	x1 <- as.spam(x1)
	x1beta <- x1%*%beta
	zg <- z.sp%*%g

	pred <- x1beta + zg + AMMI

	ve   <- c((t(y-pred)%*%(y-pred))/n)
	va   <- c((t(g)%*%g)/ngen)


	niter <- iter*jump + burn


	gen.chain <- matrix(0, nrow=niter, ncol=nlevels(Gen))
	rep.chain <- matrix(0, nrow=niter, ncol=length(beta))
	comp.var <- matrix(0, nrow=niter, ncol=length(c(va,ve)))
	autovU1 <- matrix(0, nrow=niter, ncol=nrow(U))
	autovU2 <- autovU1
	l.list <- matrix(0, nrow=niter, ncol=length(L))
	autoV1 <- matrix(0, nrow=niter, ncol=nrow(V))
	autoV2 <- autoV1
	pred.chain <- matrix(0,nrow=nrow(pred), ncol=niter)

	InvG <- diag.spam(ngen)

	invbeta <- solve(crossprod.spam(x1))
	invbeta <- as.spam(invbeta)

	zz <- crossprod.spam(z.sp)


	invg <- diag.spam(ngen)
	inicio <- proc.time()

  pb <- txtProgressBar(min = 1, max=niter, style=3, char=' \U21D2')

	for(itera in 1:niter)
	{
		ve <- c(ve)
		va <- c(va)

		A1 <- InvG*(ve/va)


		invbx1 <- tcrossprod.spam(invbeta,x1)

		zg <- z.sp%*%g
		izgami <- y-zg-AMMI
		beta1 <- invbx1%*%izgami

		varbeta <- chol(invbeta*ve)

		vbn <- crossprod.spam(varbeta,as.spam(rnorm(nbloc)))
		beta    <- beta1+vbn

		zza <- zz+A1

		invg <- solve(zza)
		invg <- as.spam(invg)

		invgz <- tcrossprod.spam(invg,z.sp)

		x1beta <- x1%*%beta
		yzba <- y-x1beta-AMMI
		g1 <- invgz%*%yzba
		varg <- chol(invg*ve)

		vgn <- crossprod.spam(varg,as.spam(rnorm(ngen)))
		g <- g1+vgn

		zg <- z.sp%*%g
		yxbzg <- y-x1beta-zg


		for (i in 1:s)
		{

			zU <- z.sp%*%U.sp[,i]
			diagzu <- diag.spam(c(zU))
			dzux <- diagzu%*%x.sp
			z3 <- dzux%*%as.spam(V.sp[,i])


			z3z <- crossprod.spam(z3)
			solvez3z <- solve(z3z)
			sz3z <- tcrossprod.spam(solvez3z,z3)

			L1 <- sz3z%*%yxbzg

			varl <- c(sqrt(solvez3z*ve))

			if (i==1){

				L[i] <- rtnorm(1,c(L1),varl, lower=0)

				xv <- x.sp%*%V.sp[,i]
				dxv <- diag.spam(c(xv))
				w1 <- dxv%*%z.sp


				alpha <- crossprod.spam(w1,yxbzg)

				Hg    <- cbind(matrix(1,ngen,1),matrix(0,ngen,ngen-i))
				Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)

				x.qr <- qr(Hg)
				Q <- as.matrix(qr.Q(x.qr))
				Q <- as.spam(Q)


				alpha1 <- crossprod(alpha, Q)
				alpha2 <- tcrossprod.spam(alpha1,Q)
				norm <- c(sqrt(alpha2%*%alpha))

				Q <- Q[,(i+1):ncol(Q)]

				alphalinha <- crossprod.spam(Q,alpha)/norm

				mass <-(L[i]*norm)/ve


				autvg <- as.matrix(rmovMF(1,c(mass*alphalinha)))
				class(autvg) <- "matrix"
				autvg <- as.spam(autvg)
				U.sp[,i] <- tcrossprod.spam(Q,autvg)

				zU <- z.sp%*%U.sp[,i]
				dzu <- diag.spam(c(zU))
				w2 <- dzu%*%x.sp

				ipso <- crossprod.spam(w2,yxbzg)

				He   <- cbind(matrix(1,namb,1),matrix(0,namb,(namb-i)))
				He[1:(namb-i),(i+1):ncol(He)] <- diag((namb-i))
				x.qr <- qr(He)
				Q    <- qr.Q(x.qr)
				Q    <- Q[,(i+1):ncol(Q)]
				Q <- as.spam(Q)

				ipsoq <- crossprod.spam(ipso,Q)
				ipqq <- tcrossprod.spam(ipsoq,Q)
				norm <- c(sqrt(ipqq%*%ipso))

				ipsolinha <- crossprod.spam(Q,ipso)/norm
				mass <- c((L[i]*norm)/ve)

				autve<- rmovMF(1,c(mass*ipsolinha))
				class(autve) <- "matrix"
				autve <- as.spam(autve)

				V.sp[,i]<- tcrossprod.spam(Q,autve)
			}

			if (i>1) 
			{
				L[i] <- rtnorm(1,c(L1),c(varl), lower=0, upper=L[i-1])

				xv <- x.sp%*%V.sp[,i]
				diagxv <- diag.spam(c(xv))
				w1 <- diagxv%*%z.sp		

				alpha <- crossprod.spam(w1,yxbzg)

				Hg    <- cbind(matrix(1,ngen,1),U.sp[,k<i],matrix(0,ngen,ngen-i))
				Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
				# 			Hg <- Matrix(Hg, sparse=TRUE)
				x.qr <- qr(Hg)
				Q <- qr.Q(x.qr)
				Q <- Q[,(i+1):ncol(Q)]
				Q <- as.spam(Q)

				alpha1 <- crossprod.spam(alpha, Q)
				alpha2 <- tcrossprod.spam(alpha1,Q)
				norm <- c(sqrt(alpha2%*%alpha))

				alphalinha <- crossprod.spam(Q,alpha)/norm

				mass <- c((L[i]*norm)/ve)

				autvg<- rmovMF(1,c(mass*alphalinha))
				class(autvg) <- "matrix"
				autvg <- as.spam(autvg)

				U.sp[,i]<- tcrossprod.spam(Q,autvg)

				zu <- z.sp%*%U.sp[,i]
				dzu <- diag.spam(c(zu))
				w2 <- dzu%*%x.sp

				ipso <- crossprod.spam(w2,yxbzg)

				He  <- cbind(matrix(1,namb,1),V.sp[,k<i],matrix(0,namb,(namb-i)))
				He[1:(namb-i),(i+1):ncol(He)] <- diag(namb-i)
				x.qr <- qr(He)
				Q    <- qr.Q(x.qr)
				Q    <- Q[,(i+1):ncol(Q)]
				Q <- as.spam(Q)

				ipsoq <- crossprod.spam(ipso,Q)
				ipsoqq <- tcrossprod.spam(ipsoq,Q)
				norm <- c(sqrt(ipsoqq%*%ipso))

				ipsolinha <- crossprod.spam(Q,ipso)/norm

				mass <- c((L[i]*norm)/ve)

				if(i<s){
					autve <- rmovMF(1,c(mass*ipsolinha))
					class(autve) <- "matrix"
					autve <- as.spam(autve)
					V.sp[,i] <- tcrossprod(Q,autve)
				}
				if(i==s){V.sp[,i] <- Q%*%ipsolinha}
			}
		}

		zu <- z.sp%*%U.sp
		xv <- x.sp%*%V.sp
		zuxv <- zu*xv
		AMMI <- zuxv%*%L

		zg <- z.sp%*%g
		z1bzg <- x1beta+zg
		pred <- z1bzg+AMMI

		erro <- t(y-pred)%*%(y-pred)

		ginvg <- crossprod.spam(g,InvG)
		ssg  <- ginvg%*%g

		rve  <- rchisq(1,(n))
		ve   <- (erro/rve)
		rva  <- rchisq(1,(ngen))
		va   <- (ssg/rva)  

#		pb <- txtProgressBar(min = 1, max=niter, style=3)
		setTxtProgressBar(pb, itera)


		comp.var[itera,] <- c(va,ve)
		rep.chain[itera,] <- c(beta)
		gen.chain[itera, ] <- g


		pred.chain[,itera] <- pred


		autovU1[itera,] <- c(U.sp[,1])
		autovU2[itera,] <- c(U.sp[,2])

		l.list[itera,] <- L

		autoV1[itera,] <- c(V.sp[,1])
		autoV2[itera,] <- c(V.sp[,2])

	
	}

	fim <- proc.time()-inicio
	cat("\n")
	cat("Elapsed time:", paste(round(fim[3]/60,3), "minutes", sep=" "), "\n")

	cp.var <- comp.var[-c(1:burn),]
	atu1 <- autovU1[-c(1:burn),]
	atu2 <- autovU2[-c(1:burn),]
	atv1 <- autoV1[-c(1:burn),]
	atv2 <- autoV2[-c(1:burn),]
	ll <- l.list[-c(1:burn),]
	r.chain <- rep.chain[-c(1:burn),]
	gt.chain <- gen.chain[-c(1:burn),]
	pred.chain <- pred.chain[,-c(1:burn)]

	adjust <- seq(1,iter*jump, by=jump)

	cp.var <- cp.var[c(adjust),]
	atu1 <- atu1[c(adjust),]
	atu2 <- atu2[c(adjust),]
	atv1 <- atv1[c(adjust),]
	atv2 <- atv2[c(adjust),]
	ll <- ll[c(adjust),]
	r.chain <- r.chain[c(adjust),]
	gt.chain <- gt.chain[c(adjust),]
	pred.chain <- pred.chain[,c(adjust)]

	colnames(cp.var) <- c("Var.gen","Var.error")
	colnames(atu1) <- levels(Gen)
	colnames(atu2) <- levels(Gen)
	colnames(atv1) <- levels(Env)
	colnames(atv2) <- levels(Env)

	tamenv <- nlevels(Env)-1
  colnames(ll) <- paste("L", 1:tamenv, sep=".")

	colnames(r.chain) <- paste("Rep", levels(Rep), sep=".")
	colnames(gt.chain) <- levels(Gen)

	output <- list(cpvar=cp.var, atu1=atu1,
								 atu2=atu2, atv1=atv1,
								 atv2=atv2, L=ll, rep.chain=r.chain, gen.chain=gt.chain,
								 pred.chain=pred.chain, time.el=fim)
	return(output)
}

#--------------------------------------------------------------

AMMIGBlupD <- function(Y=NULL, Gen=NULL, Env=NULL, Rep=NULL, M=NULL, 
                         iter=iter, jump=jump,
                         Var.error=0.5, Var.env=0.5, Var.a = 0.5, Var.d = 0.5, Var.gen=NULL,
                         burn=burn, cadeia=cadeia){
  
  NE <- nlevels(factor(Env))
  NG <- nlevels(factor(Gen))
  
  x  <- Env
  x1 <- Rep
  z  <- Gen
  
  p <- apply(M,2,sum)/(2*nrow(M))
  M0 <- round(M,0)
  W <- M0
  for(i in 1:ncol(W)){
    W[,i][W[,i]==0] <- -2*p[i]
    W[,i][W[,i]==1] <- 1-2*p[i]
    W[,i][W[,i]==2] <- 2-2*p[i]
  }
  S <- M0
  for(i in 1:ncol(S)){
    S[,i][S[,i]==0] <- -2*(p[i])^2
    S[,i][S[,i]==1] <- 2*p[i]*(1-p[i])
    S[,i][S[,i]==2] <- -2*(1-p[i])^2
  }
  
  A <- (W%*%t(W))/sum(2*p*(1-p))
  D <- (S%*%t(S))/sum((2*p*(1-p))^2)
  
  AmatM <- solve(A+diag(0.0001,NG,NG))
  AmatD <- solve(D+diag(0.0001,NG,NG))
  
  x  <- model.matrix(~x -1)
  x1 <- model.matrix(~x1 -1)
  z  <- model.matrix(~z -1)
  z1 <- model.matrix(~z*x -1)
  
  namb  <- ncol(x) 
  ngen  <- ncol(z) 
  nbloc <- ncol(x1) 
  n <- nrow(z) 
  s <- min(namb,ngen)-1 
  
  ve  <- Var.error
  va  <- Var.a
  vd  <- Var.d
  vge <- Var.a
  
  A1 <- AmatM*(ve/va)
  A2 <- diag.spam(ngen*namb)*(vge/va)
  A3 <- AmatD*(ve/vd)

  z1.sp <- as.spam(z1)
  z.sp <- as.spam(z) 
  y.sp <- as.spam(Y)
  x1.sp <- as.spam(x1)
  x.sp <- as.spam(x)
  y <- as.spam(Y)
  
  x1x <- crossprod.spam(x1)
  sx1x <- solve(x1x)
  stx <- tcrossprod.spam(sx1x,x1.sp)
  beta <- stx%*%y
  
  tzz   <- t(z)%*%z
  tzzA1 <- tzz + A1
  tzs   <- solve(tzzA1)
  tzsz  <- tzs%*%t(z)
  
  x1beta  <- x1.sp%*%beta
  yx1beta <- y-x1beta
  a       <- tzsz%*%yx1beta

  tzz   <- t(z)%*%z
  tzzA1 <- tzz + A3 
  tzs   <- solve(tzzA1)
  tzsz  <- tzs%*%t(z)
  
  x1beta  <- x1.sp%*%beta
  yx1beta <- y - x1beta - z%*%a
  d       <- tzsz%*%yx1beta
  
  g <- a + d

  z1.sp <- z1.sp[,(ngen+namb+1):ncol(z1.sp)]
  
  pa1 <- crossprod.spam(z1.sp)
  pa1 <- pa1+A2
  part1 <- solve(pa1)
  part1z1 <- tcrossprod.spam(part1,z1.sp)
  
  zg <- z.sp%*%g
  
  part2 <- yx1beta-zg
  ge <- part1z1%*%part2
  
  gem  <- as.spam(matrix(0,ngen,namb))
  
  for(j in 1:namb){
    if (j==1) gem[,j]=ge[j:ngen] else gem[,j]=ge[((j-1)*ngen+1):(ngen*j)] 
  }
  
  dec <- svd(gem)
  U  <- dec$u
  L  <- dec$d
  V  <- dec$v
  k  <- 1:s
  U  <- U[,1:s]
  L  <- L[1:s]
  V  <- V[,1:s]
  
  U.sp <- as.spam(U)
  L.sp <- as.spam(L)
  V.sp <- as.spam(V)
  
  cat("\n")
  cat(paste("Initializing chain", cadeia, sep=" "), "\n")
  cat("\n")
  
  for(i in 1:s){
    
    zU <- c(z.sp%*%U.sp[,i])
    zUdiag <- diag.spam(zU)
    zUX <- zUdiag%*%x.sp
    z3 <- as.spam(zUX%*%V.sp[,i])
    
    z3z <- crossprod.spam(z3)
    z3solve <- solve(z3z)
    z3solvez3 <- tcrossprod.spam(z3solve,z3)	
    
    L[i] <- z3solvez3%*%part2
    
    if(i==1){
      
      xV  <- diag.spam(c(x.sp%*%V.sp[,i]))
      w1 <- xV%*%z.sp
      alpha <- crossprod.spam(w1,part2)
      
      Hg <- cbind(matrix(1,ngen,1),matrix(0,ngen,ngen-i))
      Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
      x.qr <- qr(Hg)
      Q <- qr.Q(x.qr)
      Q <- Q[,(i+1):ncol(Q)]
      
      Q <- as.spam(Q)
      alphaQ <- crossprod.spam(alpha, Q)
      AlphaQtQ <- tcrossprod.spam(alphaQ,Q)
      alphafim <- AlphaQtQ%*%alpha
      
      norm <- sqrt(c(alphafim))
      
      alphalinha <- crossprod.spam(Q,alpha)/c(norm)
      
      U.sp[,i] <- Q%*%alphalinha
      
      zu <- z.sp%*%U.sp[,i]
      zudiag <- diag.spam(c(zu))
      w2 <- zudiag%*%x.sp
      
      ipso <- crossprod.spam(w2,part2)
      
      He <- cbind(matrix(0,namb,(s)))
      He[1:s,i:ncol(He)] <- diag(s)
      x.qr <- qr(He)
      Q <- qr.Q(x.qr)
      Q <- as.matrix(Q[,i:ncol(Q)])
      Q <- as.spam(Q)
      
      norm1 <- crossprod.spam(ipso,Q) 
      norm2 <- tcrossprod.spam(norm1,Q)
      norm <- c(sqrt(norm2%*%ipso))
      
      ipsolinha <- crossprod.spam(Q,ipso)/norm
      
      V.sp[,i] <- Q%*%ipsolinha
      
    }
    if(i>1){
      
      xv <- x.sp%*%V.sp[,i]
      xvd <- diag.spam(c(xv))
      w1 <- xvd%*%z.sp
      
      alpha <- crossprod.spam(w1,part2)
      
      Hg <- cbind(matrix(1,ngen,1),U.sp[,k<i],matrix(0,ngen,ngen-i))
      Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
      x.qr <- qr(Hg)
      Q <- qr.Q(x.qr)
      Q <- as.spam(Q)
      
      norm1 <- crossprod.spam(alpha,Q) 
      norm2 <- tcrossprod.spam(norm1,Q)
      norm <- c(sqrt(norm2%*%alpha))
      
      Q <- Q[,(i+1):ncol(Q)]
      
      qalpha <- crossprod.spam(Q,alpha)
      alphalinha <- qalpha/norm
      
      U.sp[,i] <- Q%*%alphalinha
      
      zU <- z.sp%*%U.sp[,i]    
      zUd <- diag.spam(c(zU))
      w2 <- zUd%*%x.sp
      
      ipso <- crossprod.spam(w2,part2)
      
      He <- cbind(V.sp[,k<i],matrix(0,namb,(namb-i+1)))
      He[1:(namb-i+1),i:ncol(He)] <- diag(namb-i+1)
      x.qr <- qr(He)
      Q <- qr.Q(x.qr)
      Q <- as.spam(Q)
      
      norm1 <- crossprod.spam(ipso,Q)
      norm2 <- tcrossprod.spam(norm1,Q)
      norm <- c(sqrt(norm2%*%ipso))
      
      Q <- Q[,i:ncol(Q)]
      ipsolinha <- crossprod.spam(Q,ipso)/norm
      
      V.sp[,i] <- Q%*%ipsolinha
    }
  }
  
  zU <- z.sp%*%U.sp
  xV <- x.sp%*%V.sp
  zuv <- zU*xV
  AMMI <- zuv%*%L
  
  x1     <- as.spam(x1)
  x1beta <- x1%*%beta
  zg     <- z.sp%*%g
  
  pred   <- x1beta + zg + AMMI
  
  ve     <- c((t(y-pred)%*%(y-pred))/n)
  va     <- c((t(a)%*%a)/ngen)       
  vd     <- c((t(d)%*%d)/ngen)       
  
  niter <- iter*jump + burn
  
  
  gen.chain <- matrix(0, nrow=niter, ncol=nlevels(Gen))
  gen.a.chain <- matrix(0, nrow=niter, ncol=nlevels(Gen))
  gen.d.chain <- matrix(0, nrow=niter, ncol=nlevels(Gen))
  rep.chain <- matrix(0, nrow=niter, ncol=length(beta))
  comp.var <- matrix(0, nrow=niter, ncol=length(c(va,vd,ve)))
  autovU1 <- matrix(0, nrow=niter, ncol=nrow(U))
  autovU2 <- autovU1
  l.list <- matrix(0, nrow=niter, ncol=length(L))
  autoV1 <- matrix(0, nrow=niter, ncol=nrow(V))
  autoV2 <- autoV1
  pred.chain <- matrix(0,nrow=nrow(pred), ncol=niter)

  beta.chain <- matrix(0, nrow=niter, ncol=nrow(beta))
  autovUi <- list()
  length(autovUi) <- s
  for(indice in 1:s) autovUi[[indice]] <- matrix(0,nrow=niter,ncol=NG)
  autoVi <- list()
  length(autoVi) <- s
  for(indice in 1:s) autoVi[[indice]] <- matrix(0,nrow=niter,ncol=NE)

  InvA <- AmatM    
  InvD <- AmatD     

  invbeta <- solve(crossprod.spam(x1))
  invbeta <- as.spam(invbeta)
  
  zz <- t(z)%*%z

  inva <- AmatM
  invd <- AmatD
  
  inicio <- proc.time()

  pb <- txtProgressBar(min = 1, max=niter, style=3, char=' \U21D2')


  for(itera in 1:niter){
    ve <- c(ve)
    va <- c(va)
    vd <- c(vd)

    A1 <- InvA*(ve/va)
    A3 <- InvD*(ve/vd)

    invbx1 <- tcrossprod.spam(invbeta,x1)
    
    zg      <- z.sp%*%g
    izgami  <- y-zg-AMMI
    beta1   <- invbx1%*%izgami
    varbeta <- chol(invbeta*ve)
    vbn     <- crossprod.spam(varbeta,as.spam(rnorm(nbloc)))
    beta    <- beta1+vbn
  
    zza    <- zz + A1
    inva   <- solve(zza)
    invaz  <- inva%*%t(z)
    x1beta <- x1%*%beta
    yzba   <- y - x1beta - z%*%d - AMMI
    a1     <- invaz%*%yzba
    vara   <- chol(inva*ve)
    van    <- crossprod.spam(vara,as.spam(rnorm(ngen)))     
    a      <- a1+van

    zzd    <- zz + A3
    invd   <- solve(zzd)
    invdz <- invd%*%t(z)
    x1beta <- x1%*%beta
    yzbd   <- y - x1beta - z%*%a - AMMI
    d1     <- invdz%*%yzbd
    vard   <- chol(invd*ve)
    vdn    <- crossprod.spam(vard,as.spam(rnorm(ngen))) 
    d      <- d1+vdn
    
    g      <- a + d

    zg <- z.sp%*%g
    yxbzg <- y -x1beta-zg
    
    for(i in 1:s){
      zU <- z.sp%*%U.sp[,i]
      diagzu <- diag.spam(c(zU))
      dzux <- diagzu%*%x.sp
      z3 <- dzux%*%as.spam(V.sp[,i])
      z3z <- crossprod.spam(z3)
      solvez3z <- solve(z3z)
      sz3z <- tcrossprod.spam(solvez3z,z3)
      L1 <- sz3z%*%yxbzg
      
      varl <- c(sqrt(solvez3z*ve))
      
      if (i==1){
        
        L[i] <- rtnorm(1,c(L1),varl, lower=0)
        
        xv <- x.sp%*%V.sp[,i]
        dxv <- diag.spam(c(xv))
        w1 <- dxv%*%z.sp

        alpha <- crossprod.spam(w1,yxbzg)
        
        Hg    <- cbind(matrix(1,ngen,1),matrix(0,ngen,ngen-i))
        Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
        x.qr <- qr(Hg)
        Q <- as.matrix(qr.Q(x.qr))
        Q <- as.spam(Q)
        alpha1 <- crossprod(alpha, Q)
        alpha2 <- tcrossprod.spam(alpha1,Q)
        norm <- c(sqrt(alpha2%*%alpha))
        Q <- Q[,(i+1):ncol(Q)]
        alphalinha <- crossprod.spam(Q,alpha)/norm
        mass <-(L[i]*norm)/ve
        autvg <- as.matrix(rmovMF(1,c(mass*alphalinha)))
        class(autvg) <- "matrix"
        autvg <- as.spam(autvg)
        U.sp[,i] <- tcrossprod.spam(Q,autvg)
        
        zU <- z.sp%*%U.sp[,i]
        dzu <- diag.spam(c(zU))
        w2 <- dzu%*%x.sp
        ipso <- crossprod.spam(w2,yxbzg)
        He   <- cbind(matrix(1,namb,1),matrix(0,namb,(namb-i)))
        He[1:(namb-i),(i+1):ncol(He)] <- diag((namb-i))
        x.qr <- qr(He)
        Q    <- qr.Q(x.qr)
        Q    <- Q[,(i+1):ncol(Q)]
        Q <- as.spam(Q)
        ipsoq <- crossprod.spam(ipso,Q)
        ipqq <- tcrossprod.spam(ipsoq,Q)
        norm <- c(sqrt(ipqq%*%ipso))
        ipsolinha <- crossprod.spam(Q,ipso)/norm
        mass <- c((L[i]*norm)/ve)
        autve<- rmovMF(1,c(mass*ipsolinha))
        class(autve) <- "matrix"
        autve <- as.spam(autve)
        
        V.sp[,i]<- tcrossprod.spam(Q,autve)
      }
      
      if (i>1) 
      {
        L[i] <- rtnorm(1,c(L1),c(varl), lower=0, upper=L[i-1])
        
        xv <- x.sp%*%V.sp[,i]
        diagxv <- diag.spam(c(xv))
        w1 <- diagxv%*%z.sp		
        alpha <- crossprod.spam(w1,yxbzg)
        Hg    <- cbind(matrix(1,ngen,1),U.sp[,k<i],matrix(0,ngen,ngen-i))
        Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
        x.qr <- qr(Hg)
        Q <- qr.Q(x.qr)
        Q <- Q[,(i+1):ncol(Q)]
        Q <- as.spam(Q)
        alpha1 <- crossprod.spam(alpha, Q)
        alpha2 <- tcrossprod.spam(alpha1,Q)
        norm <- c(sqrt(alpha2%*%alpha))
        alphalinha <- crossprod.spam(Q,alpha)/norm
        mass <- c((L[i]*norm)/ve)
        autvg<- rmovMF(1,c(mass*alphalinha))
        class(autvg) <- "matrix"
        autvg <- as.spam(autvg)
        U.sp[,i]<- tcrossprod.spam(Q,autvg)
        
        zu <- z.sp%*%U.sp[,i]
        dzu <- diag.spam(c(zu))
        w2 <- dzu%*%x.sp
        ipso <- crossprod.spam(w2,yxbzg)
        He  <- cbind(matrix(1,namb,1),V.sp[,k<i],matrix(0,namb,(namb-i)))
        He[1:(namb-i),(i+1):ncol(He)] <- diag(namb-i)
        x.qr <- qr(He)
        Q    <- qr.Q(x.qr)
        Q    <- Q[,(i+1):ncol(Q)]
        Q <- as.spam(Q)
        ipsoq <- crossprod.spam(ipso,Q)
        ipsoqq <- tcrossprod.spam(ipsoq,Q)
        norm <- c(sqrt(ipsoqq%*%ipso))
        ipsolinha <- crossprod.spam(Q,ipso)/norm
        mass <- c((L[i]*norm)/ve)
        
        if(i<s){
          autve <- rmovMF(1,c(mass*ipsolinha))
          class(autve) <- "matrix"
          autve <- as.spam(autve)
          V.sp[,i] <- tcrossprod(Q,autve)
        }
        if(i==s){V.sp[,i] <- Q%*%ipsolinha}
      }
    }
    
    zu <- z.sp%*%U.sp
    xv <- x.sp%*%V.sp
    zuxv <- zu*xv
    AMMI <- zuxv%*%L
    
    zg <- z.sp%*%g
    z1bzg <- x1beta+zg
    pred <- z1bzg+AMMI
    
    erro <- t(y-pred)%*%(y-pred)
    rve  <- rchisq(1,(n))
    ve   <- (erro/rve)

    ginva <- crossprod(a,InvA)   
    ssa  <- ginva%*%a
    rva  <- rchisq(1,(ngen))         
    va   <- (ssa/rva)  

    ginvd <- crossprod(d,InvD)    
    ssd  <- ginvd%*%d
    rvd  <- rchisq(1,(ngen))          
    vd   <- (ssd/rvd)  

 #   pb <- txtProgressBar(min = 1, max=niter, style=3)
    setTxtProgressBar(pb, itera)
    
    comp.var[itera,] <- c(va,vd,ve)
    rep.chain[itera,] <- c(beta)
    
    gen.chain[itera, ]   <- g
    
    gen.a.chain[itera, ] <- a
    gen.d.chain[itera, ] <- d
    
    pred.chain[,itera] <- pred
    
    autovU1[itera,] <- c(U.sp[,1])
    autovU2[itera,] <- c(U.sp[,2])
     
    l.list[itera,] <- L
    
    autoV1[itera,] <- c(V.sp[,1])
    autoV2[itera,] <- c(V.sp[,2])
    
    for(indice in 1:s){
      autovUi[[indice]][itera,] <- c(U.sp[,indice])
      autoVi[[indice]][itera,] <- c(V.sp[,indice])
    } 
    beta.chain[itera,] <- c(beta)
  }
  
  fim <- proc.time()-inicio
  cat("\n")
  cat("Elapsed time:", paste(round(fim[3]/60,3), "minutes", sep=" "), "\n")
  
  cp.var <- comp.var[-c(1:burn),]
  atu1 <- autovU1[-c(1:burn),]
  atu2 <- autovU2[-c(1:burn),]
  atv1 <- autoV1[-c(1:burn),]
  atv2 <- autoV2[-c(1:burn),]
  ll <- l.list[-c(1:burn),]
  r.chain <- rep.chain[-c(1:burn),]
  gt.chain <- gen.chain[-c(1:burn),]
  gt.chain.a <- gen.a.chain[-c(1:burn),]
  gt.chain.d <- gen.d.chain[-c(1:burn),]
  pred.chain <- pred.chain[,-c(1:burn)]

  atui <- autovUi
  atvi <- autoVi
  for(indice in 1:s){
    atui[[indice]] <- autovUi[[indice]][-c(1:burn),]
    atvi[[indice]] <- autoVi[[indice]][-c(1:burn),]
  }
  beta.chain <- beta.chain[-c(1:burn),]

  adjust <- seq(1,iter*jump, by=jump)
  
  cp.var <- cp.var[c(adjust),]
  atu1 <- atu1[c(adjust),]
  atu2 <- atu2[c(adjust),]
  atv1 <- atv1[c(adjust),]
  atv2 <- atv2[c(adjust),]
  ll <- ll[c(adjust),]
  r.chain <- r.chain[c(adjust),]
  gt.chain <- gt.chain[c(adjust),]
  gt.chain.a <- gt.chain.a[c(adjust),]   
  gt.chain.d <- gt.chain.d[c(adjust),]  
  pred.chain <- pred.chain[,c(adjust)]
 
  for(indice in 1:s){
    atui[[indice]] <- atui[[indice]][c(adjust),]
    atvi[[indice]] <- atvi[[indice]][c(adjust),]
  }
  beta.chain <- beta.chain[c(adjust),]

  colnames(cp.var) <- c("Var.a","Var.d","Var.error")
  colnames(atu1) <- levels(Gen)
  colnames(atu2) <- levels(Gen)
  colnames(atv1) <- levels(Env)
  colnames(atv2) <- levels(Env)

  for(indice in 1:s){
    colnames(atui[[indice]]) <- levels(Gen)
    colnames(atvi[[indice]]) <- levels(Env)
  }

  tamenv <- nlevels(Env)-1
  colnames(ll) <- paste("L", 1:tamenv, sep=".")
  
  colnames(r.chain) <- paste("Rep", levels(Rep), sep=".")
  colnames(gt.chain) <- levels(Gen)
  colnames(gt.chain.a) <- levels(Gen)
  colnames(gt.chain.d) <- levels(Gen)
  
  output <- list(cpvar=cp.var, atu1=atu1,
                 atu2=atu2, atv1=atv1,
                 atv2=atv2, L=ll, rep.chain=r.chain, gen.chain=gt.chain,
                 pred.chain=pred.chain, a.chain = gt.chain.a, d.chain = gt.chain.d,time.el=fim,
                 atui=atui, atvi=atvi,beta.chain=beta.chain)
  return(output)
} 


######


AMMIGBlup <- function(Y=NULL, Gen=NULL, Env=NULL, Rep=NULL, M=NULL,
                        iter=iter, jump=jump,
                        Var.error=0.5, Var.env=0.5, Var.gen=0.5,  Var.a = NULL, Var.d = NULL,
                        burn=burn, cadeia=cadeia){

  NE <- nlevels(factor(Env))
  NG <- nlevels(factor(Gen))
  
  x  <- Env
  x1 <- Rep
  z  <- Gen
  
  p <- apply(M,2,sum)/(2*nrow(M))
  M0 <- round(M,0)
  W <- M0
  for(i in 1:ncol(W)){
    W[,i][W[,i]==0] <- -2*p[i]
    W[,i][W[,i]==1] <- 1-2*p[i]
    W[,i][W[,i]==2] <- 2-2*p[i]
  }
  A <- (W%*%t(W))/sum(2*p*(1-p))
  AmatM <- solve(A+diag(0.0001,NG,NG))
  
  x  <- model.matrix(~x -1)
  x1 <- model.matrix(~x1 -1)
  z  <- model.matrix(~z -1)
  z1 <- model.matrix(~z*x -1)
  
  namb  <- ncol(x) 
  ngen  <- ncol(z) 
  nbloc <- ncol(x1) 
  n <- nrow(z) 
  s <- min(namb,ngen)-1 
  
  ve  <- Var.error
  va  <- Var.env
  vge <- Var.gen
  
  A1 <- AmatM*(ve/va)
  A2 <- diag.spam(ngen*namb)*(vge/va)
  
  z1.sp <- as.spam(z1)
  z.sp <- as.spam(z) # Sparse matrix
  y.sp <- as.spam(Y)
  x1.sp <- as.spam(x1)
  x.sp <- as.spam(x)
  y <- as.spam(Y)
  
  x1x <- crossprod.spam(x1)
  sx1x <- solve(x1x)
  stx <- tcrossprod.spam(sx1x,x1.sp)
  beta <- stx%*%y
  
  tzz   <- t(z)%*%z
  tzzA1 <- tzz+A1
  tzs <- solve(tzzA1)
  tzsz <- tzs%*%t(z)
  
  x1beta  <- x1.sp%*%beta
  yx1beta <- y-x1beta
  g       <- tzsz%*%yx1beta
  
  z1.sp <- z1.sp[,(ngen+namb+1):ncol(z1.sp)]
  
  pa1 <- crossprod.spam(z1.sp)
  pa1 <- pa1+A2
  part1 <- solve(pa1)
  part1z1 <- tcrossprod.spam(part1,z1.sp)
  
  zg <- z.sp%*%g
  
  part2 <- yx1beta-zg
  ge <- part1z1%*%part2
  
  gem  <- as.spam(matrix(0,ngen,namb))
  
  for(j in 1:namb){
    if (j==1) gem[,j]=ge[j:ngen] else gem[,j]=ge[((j-1)*ngen+1):(ngen*j)] 
  }
  
  dec <- svd(gem)
  U  <- dec$u
  L  <- dec$d
  V  <- dec$v
  k  <- 1:s
  U  <- U[,1:s]
  L  <- L[1:s]
  V  <- V[,1:s]
  
  U.sp <- as.spam(U)
  L.sp <- as.spam(L)
  V.sp <- as.spam(V)
  
  cat("\n")
  cat(paste("Initializing chain", cadeia, sep=" "), "\n")
  cat("\n")
  
  for(i in 1:s){
    
    zU <- c(z.sp%*%U.sp[,i])
    zUdiag <- diag.spam(zU)
    zUX <- zUdiag%*%x.sp
    z3 <- as.spam(zUX%*%V.sp[,i])
    
    z3z <- crossprod.spam(z3)
    z3solve <- solve(z3z)
    z3solvez3 <- tcrossprod.spam(z3solve,z3)	
    
    L[i] <- z3solvez3%*%part2
    
    if(i==1){
      
      xV  <- diag.spam(c(x.sp%*%V.sp[,i]))
      w1 <- xV%*%z.sp
      alpha <- crossprod.spam(w1,part2)
      
      Hg <- cbind(matrix(1,ngen,1),matrix(0,ngen,ngen-i))
      Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
      x.qr <- qr(Hg)
      Q <- qr.Q(x.qr)
      Q <- Q[,(i+1):ncol(Q)]
      
      Q <- as.spam(Q)
      alphaQ <- crossprod.spam(alpha, Q)
      AlphaQtQ <- tcrossprod.spam(alphaQ,Q)
      alphafim <- AlphaQtQ%*%alpha
      
      norm <- sqrt(c(alphafim))
      
      alphalinha <- crossprod.spam(Q,alpha)/c(norm)
      
      U.sp[,i] <- Q%*%alphalinha
      
      zu <- z.sp%*%U.sp[,i]
      zudiag <- diag.spam(c(zu))
      w2 <- zudiag%*%x.sp
      
      ipso <- crossprod.spam(w2,part2)
      
      He <- cbind(matrix(0,namb,(s)))
      He[1:s,i:ncol(He)] <- diag(s)
      x.qr <- qr(He)
      Q <- qr.Q(x.qr)
      Q <- as.matrix(Q[,i:ncol(Q)])
      Q <- as.spam(Q)
      
      norm1 <- crossprod.spam(ipso,Q) 
      norm2 <- tcrossprod.spam(norm1,Q)
      norm <- c(sqrt(norm2%*%ipso))
      
      ipsolinha <- crossprod.spam(Q,ipso)/norm
      
      V.sp[,i] <- Q%*%ipsolinha
      
    }
    if(i>1){
      
      xv <- x.sp%*%V.sp[,i]
      xvd <- diag.spam(c(xv))
      w1 <- xvd%*%z.sp
      
      alpha <- crossprod.spam(w1,part2)
      
      Hg <- cbind(matrix(1,ngen,1),U[,k<i],matrix(0,ngen,ngen-i))
      Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
      x.qr <- qr(Hg)
      Q <- qr.Q(x.qr)
      Q <- as.spam(Q)
      
      norm1 <- crossprod.spam(alpha,Q) 
      norm2 <- tcrossprod.spam(norm1,Q)
      norm <- c(sqrt(norm2%*%alpha))
      
      Q <- Q[,(i+1):ncol(Q)]
      
      qalpha <- crossprod.spam(Q,alpha)
      alphalinha <- qalpha/norm
      
      U.sp[,i] <- Q%*%alphalinha
      
      zU <- z.sp%*%U.sp[,i]    
      zUd <- diag.spam(c(zU))
      w2 <- zUd%*%x.sp
      
      ipso <- crossprod.spam(w2,part2)
      
      He <- cbind(V[,k<i],matrix(0,namb,(namb-i+1)))
      He[1:(namb-i+1),i:ncol(He)] <- diag(namb-i+1)
      x.qr <- qr(He)
      Q <- qr.Q(x.qr)
      Q <- as.spam(Q)
      
      norm1 <- crossprod.spam(ipso,Q)
      norm2 <- tcrossprod.spam(norm1,Q)
      norm <- c(sqrt(norm2%*%ipso))
      
      Q <- Q[,i:ncol(Q)]
      ipsolinha <- crossprod.spam(Q,ipso)/norm
      
      V.sp[,i] <- Q%*%ipsolinha
    }
  }
  
  zU <- z.sp%*%U.sp
  xV <- x.sp%*%V.sp
  zuv <- zU*xV
  AMMI <- zuv%*%L
  
  x1 <- as.spam(x1)
  x1beta <- x1%*%beta
  zg <- z.sp%*%g
  
  pred <- x1beta + zg + AMMI
  
  ve   <- c((t(y-pred)%*%(y-pred))/n)
  va   <- c((t(g)%*%g)/ngen)
  
  
  niter <- iter*jump + burn
  
  
  gen.chain <- matrix(0, nrow=niter, ncol=nlevels(Gen))
  rep.chain <- matrix(0, nrow=niter, ncol=length(beta))
  comp.var <- matrix(0, nrow=niter, ncol=length(c(va,ve)))
  autovU1 <- matrix(0, nrow=niter, ncol=nrow(U))
  autovU2 <- autovU1
  l.list <- matrix(0, nrow=niter, ncol=length(L))
  autoV1 <- matrix(0, nrow=niter, ncol=nrow(V))
  autoV2 <- autoV1
  pred.chain <- matrix(0,nrow=nrow(pred), ncol=niter)
  
  InvG <- AmatM

  invbeta <- solve(crossprod.spam(x1))
  invbeta <- as.spam(invbeta)
  
  zz <- t(z)%*%z
  
  invg <- AmatM

  inicio <- proc.time()
  pb <- txtProgressBar(min = 1, max=niter, style=3, char=' \U21D2')

 
  for(itera in 1:niter){
    ve <- c(ve)
    va <- c(va)
    
    A1 <- InvG*(ve/va)

    invbx1 <- tcrossprod.spam(invbeta,x1)
    
    zg <- z.sp%*%g
    izgami <- y-zg-AMMI
    beta1 <- invbx1%*%izgami
    
    varbeta <- chol(invbeta*ve)
    
    vbn <- crossprod.spam(varbeta,as.spam(rnorm(nbloc)))
    beta    <- beta1+vbn
    
    zza <- zz+A1
    
    invg <- solve(zza)
    invgz  <- invg%*%t(z)
    
    x1beta <- x1%*%beta
    yzba <- y-x1beta-AMMI
    g1 <- invgz%*%yzba
    varg <- chol(invg*ve)
    
    vgn <- crossprod.spam(varg,as.spam(rnorm(ngen)))
    g <- g1+vgn
    
    zg <- z.sp%*%g
    yxbzg <- y-x1beta-zg
    
    for (i in 1:s){
      zU <- z.sp%*%U.sp[,i]
      diagzu <- diag.spam(c(zU))
      dzux <- diagzu%*%x.sp
      z3 <- dzux%*%as.spam(V.sp[,i])
      
      
      z3z <- crossprod.spam(z3)
      solvez3z <- solve(z3z)
      sz3z <- tcrossprod.spam(solvez3z,z3)
      
      L1 <- sz3z%*%yxbzg
      
      varl <- c(sqrt(solvez3z*ve))
      
      if (i==1){
        
        L[i] <- rtnorm(1,c(L1),varl, lower=0)
        
        xv <- x.sp%*%V.sp[,i]
        dxv <- diag.spam(c(xv))
        w1 <- dxv%*%z.sp
        
        
        alpha <- crossprod.spam(w1,yxbzg)
        
        Hg    <- cbind(matrix(1,ngen,1),matrix(0,ngen,ngen-i))
        Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
        
        x.qr <- qr(Hg)
        Q <- as.matrix(qr.Q(x.qr))
        Q <- as.spam(Q)
        
        
        alpha1 <- crossprod(alpha, Q)
        alpha2 <- tcrossprod.spam(alpha1,Q)
        norm <- c(sqrt(alpha2%*%alpha))
        
        Q <- Q[,(i+1):ncol(Q)]
        
        alphalinha <- crossprod.spam(Q,alpha)/norm
        
        mass <-(L[i]*norm)/ve
        
        
        autvg <- as.matrix(rmovMF(1,c(mass*alphalinha)))
        class(autvg) <- "matrix"
        autvg <- as.spam(autvg)
        U.sp[,i] <- tcrossprod.spam(Q,autvg)
        
        zU <- z.sp%*%U.sp[,i]
        dzu <- diag.spam(c(zU))
        w2 <- dzu%*%x.sp
        
        ipso <- crossprod.spam(w2,yxbzg)
        
        He   <- cbind(matrix(1,namb,1),matrix(0,namb,(namb-i)))
        He[1:(namb-i),(i+1):ncol(He)] <- diag((namb-i))
        x.qr <- qr(He)
        Q    <- qr.Q(x.qr)
        Q    <- Q[,(i+1):ncol(Q)]
        Q <- as.spam(Q)
        
        ipsoq <- crossprod.spam(ipso,Q)
        ipqq <- tcrossprod.spam(ipsoq,Q)
        norm <- c(sqrt(ipqq%*%ipso))
        
        ipsolinha <- crossprod.spam(Q,ipso)/norm
        mass <- c((L[i]*norm)/ve)
        
        autve<- rmovMF(1,c(mass*ipsolinha))
        class(autve) <- "matrix"
        autve <- as.spam(autve)
        
        V.sp[,i]<- tcrossprod.spam(Q,autve)
      }
      
      if (i>1) 
      {
        L[i] <- rtnorm(1,c(L1),c(varl), lower=0, upper=L[i-1])
        
        xv <- x.sp%*%V.sp[,i]
        diagxv <- diag.spam(c(xv))
        w1 <- diagxv%*%z.sp		
        
        alpha <- crossprod.spam(w1,yxbzg)
        
        Hg    <- cbind(matrix(1,ngen,1),U[,k<i],matrix(0,ngen,ngen-i))
        Hg[1:(ngen-i),(i+1):ncol(Hg)] <- diag(ngen-i)
        x.qr <- qr(Hg)
        Q <- qr.Q(x.qr)
        Q <- Q[,(i+1):ncol(Q)]
        Q <- as.spam(Q)
        
        alpha1 <- crossprod.spam(alpha, Q)
        alpha2 <- tcrossprod.spam(alpha1,Q)
        norm <- c(sqrt(alpha2%*%alpha))
        
        alphalinha <- crossprod.spam(Q,alpha)/norm
        
        mass <- c((L[i]*norm)/ve)
        
        autvg<- rmovMF(1,c(mass*alphalinha))
        class(autvg) <- "matrix"
        autvg <- as.spam(autvg)
        
        U.sp[,i]<- tcrossprod.spam(Q,autvg)
        
        zu <- z.sp%*%U.sp[,i]
        dzu <- diag.spam(c(zu))
        w2 <- dzu%*%x.sp
        
        ipso <- crossprod.spam(w2,yxbzg)
        
        He  <- cbind(matrix(1,namb,1),V[,k<i],matrix(0,namb,(namb-i)))
        He[1:(namb-i),(i+1):ncol(He)] <- diag(namb-i)
        x.qr <- qr(He)
        Q    <- qr.Q(x.qr)
        Q    <- Q[,(i+1):ncol(Q)]
        Q <- as.spam(Q)
        
        ipsoq <- crossprod.spam(ipso,Q)
        ipsoqq <- tcrossprod.spam(ipsoq,Q)
        norm <- c(sqrt(ipsoqq%*%ipso))
        
        ipsolinha <- crossprod.spam(Q,ipso)/norm
        
        mass <- c((L[i]*norm)/ve)
        
        if(i<s){
          autve <- rmovMF(1,c(mass*ipsolinha))
          class(autve) <- "matrix"
          autve <- as.spam(autve)
          V.sp[,i] <- tcrossprod(Q,autve)
        }
        if(i==s){V.sp[,i] <- Q%*%ipsolinha}
      }
    }
    
    zu <- z.sp%*%U.sp
    xv <- x.sp%*%V.sp
    zuxv <- zu*xv
    AMMI <- zuxv%*%L
    
    zg <- z.sp%*%g
    z1bzg <- x1beta+zg
    pred <- z1bzg+AMMI
    
    erro <- t(y-pred)%*%(y-pred)
    
    ginvg <- crossprod.spam(g,InvG)
    ssg  <- ginvg%*%g
    rve  <- rchisq(1,(n))
    ve   <- (erro/rve)
    rva  <- rchisq(1,(ngen))
    va   <- (ssg/rva)  
    
#    pb <- txtProgressBar(min = 1, max=niter, style=3)
    setTxtProgressBar(pb, itera)
    
    comp.var[itera,] <- c(va,ve)
    rep.chain[itera,] <- c(beta)
    gen.chain[itera, ] <- g
    
    pred.chain[,itera] <- pred
    
    autovU1[itera,] <- c(U.sp[,1])
    autovU2[itera,] <- c(U.sp[,2])
    
    l.list[itera,] <- L
    
    autoV1[itera,] <- c(V.sp[,1])
    autoV2[itera,] <- c(V.sp[,2])
  }
  
  fim <- proc.time()-inicio
  cat("\n")
  cat("Elapsed time:", paste(round(fim[3]/60,3), "minutes", sep=" "), "\n")
  
  cp.var <- comp.var[-c(1:burn),]
  atu1 <- autovU1[-c(1:burn),]
  atu2 <- autovU2[-c(1:burn),]
  atv1 <- autoV1[-c(1:burn),]
  atv2 <- autoV2[-c(1:burn),]
  ll <- l.list[-c(1:burn),]
  r.chain <- rep.chain[-c(1:burn),]
  gt.chain <- gen.chain[-c(1:burn),]
  pred.chain <- pred.chain[,-c(1:burn)]
  
  adjust <- seq(1,iter*jump, by=jump)
  
  cp.var <- cp.var[c(adjust),]
  atu1 <- atu1[c(adjust),]
  atu2 <- atu2[c(adjust),]
  atv1 <- atv1[c(adjust),]
  atv2 <- atv2[c(adjust),]
  ll <- ll[c(adjust),]
  r.chain <- r.chain[c(adjust),]
  gt.chain <- gt.chain[c(adjust),]
  pred.chain <- pred.chain[,c(adjust)]
  
  colnames(cp.var) <- c("Var.gen","Var.error")
  colnames(atu1) <- levels(Gen)
  colnames(atu2) <- levels(Gen)
  colnames(atv1) <- levels(Env)
  colnames(atv2) <- levels(Env)
  
  tamenv <- nlevels(Env)-1
  colnames(ll) <- paste("L", 1:tamenv, sep=".")
  
  colnames(r.chain) <- paste("Rep", levels(Rep), sep=".")
  colnames(gt.chain) <- levels(Gen)
  
  output <- list(cpvar=cp.var, atu1=atu1,
                 atu2=atu2, atv1=atv1,
                 atv2=atv2, L=ll, rep.chain=r.chain, gen.chain=gt.chain,
                 pred.chain=pred.chain, time.el=fim)
  return(output)
} 


