% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_dist.R
\name{surv}
\alias{surv}
\title{Generic method for obtaining the survival function of an object.}
\usage{
surv(x, ...)
}
\arguments{
\item{x}{The object to obtain the survival function of.}

\item{...}{Additional arguments to pass.}
}
\value{
A function computing the survival function \eqn{S(t) = P(X > t)}.
}
\description{
Generic method for obtaining the survival function of an object.
}
\examples{
x <- exponential(1)
S <- surv(x)
S(0)  # 1 (survival at time 0)
S(1)  # exp(-1), approximately 0.368
}
