% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{cdf.edist}
\alias{cdf.edist}
\title{CDF for expression distributions.}
\usage{
\method{cdf}{edist}(x, ...)
}
\arguments{
\item{x}{An \code{edist} object.}

\item{...}{Additional arguments forwarded to \code{cdf.empirical_dist}.}
}
\value{
A function computing the empirical CDF.
}
\description{
Falls back to \code{\link{realize}} to materialize the distribution
as an \code{\link{empirical_dist}}, then delegates to
\code{\link{cdf.empirical_dist}}.
}
\examples{
\donttest{
set.seed(1)
z <- normal(0, 1) * exponential(1)
Fz <- cdf(z)
Fz(0)
}
}
