% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_and_config.R
\name{install_aifeducation}
\alias{install_aifeducation}
\title{Install aifeducation on a machine}
\usage{
install_aifeducation(
  install_aifeducation_studio = TRUE,
  python_version = "3.12",
  cuda_version = "13.0",
  use_conda = FALSE
)
}
\arguments{
\item{install_aifeducation_studio}{\code{bool} If \code{TRUE} all necessary R packages are installed for using AI for Education
Studio.}

\item{python_version}{\code{string} Python version to use/install.}

\item{cuda_version}{\code{string} determining the requested version of cuda.}

\item{use_conda}{\code{bool} If \code{TRUE} installation installs 'miniconda' and uses 'conda' as package manager. If \code{FALSE}
installation installs python and uses virtual environments for package management.}
}
\value{
Function does nothing return. It installs python, optional R packages, and necessary 'python' packages on a
machine.
}
\description{
Function for installing 'aifeducation' on a machine.

Using a virtual environment (\code{use_conda=FALSE})
If 'python' is already installed the installed version is used. In the case that
the required version of 'python' is different from the existing version the new
version is installed. In all other cases python will be installed on the system.

#' Using a conda environment (\code{use_conda=TRUE})
If 'miniconda' is already existing on the machine no installation of 'miniconda'
is applied. In this case the system checks for update and updates 'miniconda' to
the newest version. If 'miniconda' is not found on the system it will be installed.
}
\note{
On MAC OS torch will be installed without support for cuda.
}
\seealso{
Other Installation and Configuration: 
\code{\link{check_aif_py_modules}()},
\code{\link{get_recommended_py_versions}()},
\code{\link{install_aifeducation_studio}()},
\code{\link{install_py_modules}()},
\code{\link{prepare_session}()},
\code{\link{set_transformers_logger}()},
\code{\link{update_aifeducation}()}
}
\concept{Installation and Configuration}
