% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{find_outlier}
\alias{find_outlier}
\title{find_outlier}
\usage{
find_outlier(df, var, other_var = NULL)
}
\arguments{
\item{df}{A data frame.}

\item{var}{Name of the column to check for outliers (string).}

\item{other_var}{Character vector of additional column names to return
alongside the outlier values, or \code{NULL}.}
}
\value{
A tibble with columns \code{row_index}, \code{outlier_value}, and any
  requested \code{other_var} columns.
}
\description{
Identify outliers in a numeric column using the IQR method
  (values outside 1.5 \eqn{\times} IQR from Q1/Q3).
}
\examples{
df <- data.frame(val = c(1, 2, 2, 3, 100), id = 1:5)
find_outlier(df, "val", "id")
}
