% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_contrast.R
\name{curve_contrast}
\alias{curve_contrast}
\title{Contrast multiple subgroup effect curves}
\usage{
curve_contrast(x)
}
\arguments{
\item{x}{an \code{\link{effect_curve}} object; the output of a call to \code{\link[=adrf]{adrf()}} with \code{by} supplied.}
}
\value{
An object of class \code{contrast_curve}, which inherits from \code{\link{effect_curve}}, with additional information about the groups being contrasted.
}
\description{
\code{curve_contrast()} computes the difference between effect curves across levels of a subgrouping variable supplied to \code{by} in the original call to \code{\link[=adrf]{adrf()}}.
}
\details{
\code{curve_contrast()} creates a new effect curve corresponding to the difference between effect curves in two groups. When multiple subgroups are specified by \code{by} in the original call to \code{\link[=adrf]{adrf()}}, all pairwise comparisons are included. Use the \code{subset} argument in the original function call to restrict comparisons to fewer groups.
}
\examples{
data("nhanes3lead")

fit <- lm(Math ~ poly(logBLL, 5) *
            Male * Smoke_in_Home *
            (Age + Race + PIR),
          data = nhanes3lead)

# ADRFs in Race subgroups, excluding Other
adrf_by <- adrf(fit, treat = "logBLL",
                by = ~Race,
                subset = Race != "Other")

adrf_by

# Contrast subgroup ADRFs
adrf_contrast <- curve_contrast(adrf_by)

adrf_contrast

# Plot contrast ADRFs
plot(adrf_contrast, simultaneous = FALSE)

# Compute and test difference between subgroup
# ADRFs at specific points
adrf_contrast(logBLL = c(0, 2)) |>
  summary()

# Test if ADRF differences are present
summary(adrf_contrast)
}
\seealso{
\itemize{
\item \code{\link[=adrf]{adrf()}} for computing the ADRF
\item \code{\link[=reference_curve]{reference_curve()}} for comparing effect curves to a point along the curve
\item \code{\link[=plot.effect_curve]{plot.effect_curve()}} for plotting the effect curve contrasts
\item \code{\link[=summary.curve_est]{summary.curve_est()}} for performing tests of effect curve contrasts at specific points
\item \code{\link[=summary.effect_curve]{summary.effect_curve()}} for performing omnibus tests of effect curve contrasts (e.g., whether the contrast curve differs from 0)
}
}
