% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tags.R
\name{aw_get_tags}
\alias{aw_get_tags}
\title{Get a list of tags}
\usage{
aw_get_tags(
  company_id = Sys.getenv("AW_COMPANY_ID"),
  componentId = NULL,
  componentType = NULL,
  tagNames = NULL,
  limit = 1000,
  page = 0,
  debug = FALSE
)
}
\arguments{
\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link{get_me}} to get a list of available \code{company_id} values.}

\item{componentId}{The component id being requested. Default is \code{NULL}}

\item{componentType}{The component type being requested. Options include segment, dashboard, bookmark,
calculatedMetric, project, dateRange, metric, dimension, virtualReportSuite, scheduledJob, alert, classification.
Default is NULL}

\item{tagNames}{Comma separated vector of tag names. componentType}

\item{limit}{The number of results to return per page. This argument works in conjunction with the
\code{page} argument. The default is 10.}

\item{page}{The "page" of results to display. This works in conjunction with the \code{limit} argument and is
zero-based. For instance, if \code{limit = 20} and \code{page = 1}, the results returned would be 21 through 40.}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}
}
\value{
A data frame of tags and the associated meta data.
}
\description{
Retrieve all tag names or search by component id or tag names
}
