% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{get_cov_data}
\alias{get_cov_data}
\title{Download a dataset from the Vancouver Open Data Portal}
\usage{
get_cov_data(
  dataset_id,
  select = "*",
  where = NULL,
  apikey = getOption("VancouverOpenDataApiKey"),
  rows = NULL,
  cast_types = TRUE,
  refresh = FALSE,
  ...
)
}
\arguments{
\item{dataset_id}{Dataset id from the Vancouver Open Data catalogue}

\item{select}{Column selection / expression string using
\href{https://help.opendatasoft.com/apis/ods-explore-v2/#section/Opendatasoft-Query-Language-(ODSQL)/Select-clause}{ODSQL syntax},
e.g. `"current_land_value, land_coordinate as coord"`. Default `"*"`
returns all columns.}

\item{where}{Filter expression using
\href{https://help.opendatasoft.com/apis/ods-explore-v2/#section/Opendatasoft-Query-Language-(ODSQL)/Where-clause}{ODSQL syntax},
e.g. `"tax_assessment_year='2024' AND zoning_district LIKE 'RS-'"`.
Default `NULL` returns all rows.}

\item{apikey}{Vancouver Open Data API key, default `getOption("VancouverOpenDataApiKey")`}

\item{rows}{Maximum number of rows to return. Default `NULL` returns all rows.}

\item{cast_types}{Logical; use metadata to auto-cast column types and convert
spatial datasets to `sf`. Default `TRUE`.}

\item{refresh}{Bypass the session cache and re-download, default `FALSE`}

\item{...}{Ignored; retained for compatibility with earlier versions}
}
\value{
A tibble, or an `sf` object when the dataset has a `geo_shape` field
  and `cast_types = TRUE`.
}
\description{
Downloads a dataset and returns it as a tibble or `sf` object. When
`cast_types = TRUE` (the default), field types are looked up via
[get_cov_metadata()] and columns are automatically cast to integer, numeric,
or Date. Datasets containing a `geo_shape` field are returned as an `sf`
object; if spatial conversion fails a plain tibble is returned with a warning.

Results are cached for the duration of the R session, keyed on all query
parameters. Re-running the same call does not trigger a second download.
}
\examples{
\dontrun{
# Filtered download: parking tickets on one block
get_cov_data("parking-tickets-2017-2019",
             where = "block = 1100 AND street = 'ALBERNI ST'")

# Select specific columns and limit rows (useful for exploration)
get_cov_data("property-tax-report",
             select = "tax_assessment_year, current_land_value, zoning_district",
             where = "tax_assessment_year = '2024'",
             rows = 100)

# Spatial dataset: returned automatically as an sf object
property_polygons <- get_cov_data("property-parcel-polygons")
class(property_polygons)  # "sf" "data.frame"
}

}
\seealso{
[get_cov_metadata()] for field names and types,
  [aggregate_cov_data()] for server-side aggregation,
  [search_cov_datasets()] to find dataset IDs
}
