test_that("calculate_Ts runs on example data", {

  library(terra)

  albedo <- rast(system.file("extdata", "albedo_mini.tif", package = "Ts"))
  ndvi   <- rast(system.file("extdata", "ndvi_mini.tif", package = "Ts"))
  Ta     <- rast(system.file("extdata", "Ta_mini.tif", package = "Ts"))

  Ts <- calculate_Ts(albedo, ndvi, Ta, verbose = FALSE)

  expect_s4_class(Ts, "SpatRaster")
  expect_true(all(!is.na(values(Ts))))
})
