% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvFunctions.R
\name{SurvFunc}
\alias{SurvFunc}
\title{Survival Functions}
\usage{
SurvFunc(dist, theta)
}
\arguments{
\item{dist}{String, distribution name.}

\item{theta}{Numeric parameter vector.}
}
\value{
Survival function.
}
\description{
Constructs the survival function for a parameter distribution.
}
\details{
The parameter vector theta should contain the following elements, in order,
according to the distribution:
\describe{
 \item{Exponential}{Rate \eqn{\lambda}.}
 \item{Gamma}{Shape \eqn{\alpha}, rate \eqn{\lambda}.}
 \item{Generalized Gamma}{Shape 1 \eqn{\alpha}, shape 2 \eqn{\beta}, rate \eqn{\lambda}.}
 \item{Log-Normal}{Location \eqn{\mu}, scale \eqn{\sigma}.}
 \item{Weibull}{Shape \eqn{\alpha}, rate \eqn{\lambda}.}
}
}
\examples{
# Survival function for the generalized gamma.
surv <- SurvFunc(dist = "gen-gamma", theta = c(2, 2, 2))

# Evaluation.
surv(1.0)
}
