% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataGen.R
\name{GenData}
\alias{GenData}
\title{Data Generation with Censoring}
\usage{
GenData(n, dist = "exp", theta = NULL, p = 0)
}
\arguments{
\item{n}{Integer sample size.}

\item{dist}{String, distribution name selected from among:
"exp","gamma","gen-gamma","log-normal","weibull".}

\item{theta}{Numeric parameter vector. Elements will vary according to the distribution.}

\item{p}{Expected censoring proportion.}
}
\value{
Data.frame including the observation times and status.
}
\description{
Generates data from survival distributions as parameterized in this package,
with optional non-informative random right censoring.
}
\details{
The parameter vector theta should contain the following elements, in order,
depending on the distribution:
\describe{
 \item{Exponential}{Rate \eqn{\lambda}.}
 \item{Gamma}{Shape \eqn{\alpha}, rate \eqn{\lambda}.}
 \item{Generalized Gamma}{Shape 1 \eqn{\alpha}, shape 2 \eqn{\beta}, rate \eqn{\lambda}.}
 \item{Log-Normal}{Location \eqn{\mu}, scale \eqn{\sigma}.}
 \item{Weibull}{Shape \eqn{\alpha}, rate \eqn{\lambda}.}
}
}
\examples{
# Gamma event times with shape 2 and rate 2.
# Expected censoring proportion of 20\%.
data <- GenData(n = 1e3, dist = "gamma", theta = c(2, 2), p = 0.20)

# Generalized gamma event times with shapes (2,3) and rate 1.
# Expected censoring proportion of 15\%.
data <- GenData(n = 1e3, dist = "gen-gamma", theta = c(2, 3, 1), p = 0.15)

# Log-normal event times with location 0 and rate 1.
# Expected censoring proportion of 10\%.
data <- GenData(n = 1e3, dist = "log-normal", theta = c(0, 1), p = 0.10)

# Weibull event times with shape 2 and rate 2.
# Expected censoring proportion of 5\%.
data <- GenData(n = 1e3, dist = "weibull", theta = c(2, 2), p = 0.05)
}
