% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_boot.R
\name{surv.boot}
\alias{surv.boot}
\title{Calculate standard errors for estimated CIFs and treatment effects}
\usage{
surv.boot(fit, nboot = 0, seed = NULL)
}
\arguments{
\item{fit}{A fitted object returned by the function \code{tteICE}, \code{surv.tteICE}, or \code{scr.tteICE}.}

\item{nboot}{Number of resamplings in the boostrapping method. If \code{nboot} is 0 or 1, then
asymptotic standard error based on the explicit form is calculated instead of bootstrapping.}

\item{seed}{Seed for bootstrapping.}
}
\value{
A list including
\describe{
\item{time}{Time points in both groups.}
\item{cif1}{Estimated cumulative incidence function in the treated group.}
\item{cif0}{Estimated cumulative incidence function in the control group.}
\item{se1}{Standard error of the estimated cumulative incidence function in the treated group.}
\item{se0}{Standard error of the estimated cumulative incidence function in the control group.}
\item{ate}{Estimated treatment effect (difference in cumulative incidence functions).}
\item{se}{Standard error of the estimated treatment effect.}
\item{strategy}{Strategy used.}
\item{method}{Estimation method used.}
}
}
\description{
This function calculates the standard error for the estimated potential cumulative incidence function
and treatment effect. Two methods to calculate the standard error are considered: the asymptotic standard error
based on the explicit formula and bootstrapping.
}
\seealso{
\code{\link[tteICE]{surv.tteICE}}, \code{\link[tteICE]{scr.tteICE}},
\code{\link[tteICE]{tteICE}}
}
