% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{remote_config}
\alias{remote_config}
\title{Generic Remote Launch Configuration}
\usage{
remote_config(
  command = NULL,
  args = c("", "."),
  rscript = "Rscript",
  quote = FALSE
)
}
\arguments{
\item{command}{(character) shell command for launching daemons (e.g.
\code{"ssh"}). \code{NULL} returns shell commands for manual deployment without
launching.}

\item{args}{(character vector) arguments to \code{command}, must include \code{"."} as
placeholder for the daemon launch command. May be a list of vectors for
multiple launches.}

\item{rscript}{(character) Rscript executable. Use full path if needed, or
\code{"Rscript.exe"} on Windows.}

\item{quote}{(logical) whether to quote the daemon launch command. Required
for \code{"sbatch"} and \code{"ssh"}, not for \code{"srun"}.}
}
\value{
A list in the required format to be supplied to the \code{remote} argument
of \code{\link[=daemons]{daemons()}} or \code{\link[=launch_remote]{launch_remote()}}.
}
\description{
Provides a flexible generic framework for generating the shell commands to
deploy daemons remotely.
}
\examples{
# Slurm srun example
remote_config(
  command = "srun",
  args = c("--mem 512", "-n 1", "."),
  rscript = file.path(R.home("bin"), "Rscript")
)

# SSH requires 'quote = TRUE'
remote_config(
  command = "/usr/bin/ssh",
  args = c("-fTp 22 10.75.32.90", "."),
  quote = TRUE
)

# can be used to start local daemons with special configurations
remote_config(
  command = "Rscript",
  rscript = "--default-packages=NULL --vanilla"
)

}
\seealso{
\code{\link[=ssh_config]{ssh_config()}}, \code{\link[=cluster_config]{cluster_config()}} and \code{\link[=http_config]{http_config()}} for other
types of remote configuration.
}
